/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.menu;

import com.hbm.blockentity.machine.rbmk.RBMKFuelChannelEntity;
import com.hbm.gui.ModMenuType;
import com.hbm.gui.menu.BaseMachineMenu;
import com.hbm.item.rbmk.ItemRBMKFuelRod;
import com.hbm.registries.ModBlocks;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RBMKFuelChannelMenu
extends BaseMachineMenu {
    private static final int DATA_FIELDS = 12;
    private static final int SLOT_COUNT = 2;
    private static final int FUEL_SLOT_INDEX = 0;
    private static final int OUTPUT_SLOT_INDEX = 1;
    private static final int INPUT_SLOT_X = 80;
    private static final int INPUT_SLOT_Y = 45;
    private static final int OUTPUT_SLOT_X = 80;
    private static final int OUTPUT_SLOT_Y = 45;
    private static final int PLAYER_INV_X_OFFSET = -1;
    private static final int PLAYER_INV_Y_OFFSET = 19;
    private static final int TANK_CAPACITY = 16000;
    private final ContainerLevelAccess access;

    public RBMKFuelChannelMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (RBMKFuelChannelEntity)null);
    }

    public RBMKFuelChannelMenu(int containerId, Inventory playerInventory, Container container, ContainerData data) {
        this(containerId, playerInventory, (RBMKFuelChannelEntity)null, data);
    }

    public RBMKFuelChannelMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerId, playerInventory, RBMKFuelChannelMenu.resolveFuelChannel(playerInventory, buf));
    }

    public RBMKFuelChannelMenu(int containerId, Inventory playerInventory, RBMKFuelChannelEntity channel) {
        this(containerId, playerInventory, channel, (ContainerData)(channel != null ? channel.getContainerData() : new SimpleContainerData(12)));
    }

    public RBMKFuelChannelMenu(int containerId, Inventory playerInventory, RBMKFuelChannelEntity channel, ContainerData data) {
        super((MenuType)ModMenuType.RBMK_FUEL_CHANNEL_MENU.get(), containerId, (Container)(channel != null ? channel : new SimpleContainer(2)), data);
        this.access = channel != null && channel.m_58904_() != null ? ContainerLevelAccess.m_39289_((Level)channel.m_58904_(), (BlockPos)channel.m_58899_()) : ContainerLevelAccess.f_39287_;
        this.slotNum = 2;
        RBMKFuelChannelMenu.m_38869_((Container)this.container, (int)2);
        RBMKFuelChannelMenu.m_38886_((ContainerData)data, (int)12);
        this.m_38897_(new Slot(this.container, 0, 80, 45){

            public boolean m_5857_(ItemStack stack) {
                return RBMKFuelChannelMenu.isFuelRod(stack);
            }

            public boolean m_6659_() {
                return RBMKFuelChannelMenu.this.container.m_8020_(1).m_41619_();
            }
        });
        this.m_38897_(new Slot(this.container, 1, 80, 45){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_6659_() {
                return this.m_6657_();
            }
        });
        this.addPlayerSlot(playerInventory, -1, 19);
        this.m_38884_(data);
    }

    @Override
    public boolean m_6875_(Player player) {
        return RBMKFuelChannelMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.machine_rbmk_fuel_channel.get()));
    }

    public float getHeat() {
        return (float)this.containerData.m_6413_(0) / 10.0f;
    }

    public float getMeltdownThreshold() {
        return (float)this.containerData.m_6413_(1) / 10.0f;
    }

    public int getEnergyStored() {
        return this.containerData.m_6413_(2);
    }

    public int getEnergyCapacity() {
        return this.containerData.m_6413_(3);
    }

    public int getWaterAmount() {
        return this.containerData.m_6413_(4);
    }

    public int getSteamAmount() {
        return this.containerData.m_6413_(5);
    }

    public int getBurnTimeRemaining() {
        return this.containerData.m_6413_(6);
    }

    public int getBurnTimeTotal() {
        return this.containerData.m_6413_(7);
    }

    public boolean isBurning() {
        return this.containerData.m_6413_(8) > 0;
    }

    public float getHeatPerSecond() {
        return (float)this.containerData.m_6413_(9) / 10.0f;
    }

    public int getLocalControlPercent() {
        return this.containerData.m_6413_(10);
    }

    public int getGlobalControlPercent() {
        return this.containerData.m_6413_(11);
    }

    public float getHeatRatio() {
        float meltdown = this.getMeltdownThreshold();
        if (meltdown <= 0.0f) {
            return 0.0f;
        }
        return Mth.m_14036_((float)(this.getHeat() / meltdown), (float)0.0f, (float)1.0f);
    }

    public float getEnergyRatio() {
        int capacity = this.getEnergyCapacity();
        if (capacity <= 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)this.getEnergyStored() / (float)capacity), (float)0.0f, (float)1.0f);
    }

    public float getCoolantRatio() {
        return Mth.m_14036_((float)((float)this.getWaterAmount() / 16000.0f), (float)0.0f, (float)1.0f);
    }

    public float getSteamRatio() {
        return Mth.m_14036_((float)((float)this.getSteamAmount() / 16000.0f), (float)0.0f, (float)1.0f);
    }

    public int getBurnProgressScaled(int width) {
        if (this.getBurnTimeTotal() <= 0) {
            return 0;
        }
        float consumed = (float)(this.getBurnTimeTotal() - this.getBurnTimeRemaining()) / (float)this.getBurnTimeTotal();
        return (int)((float)width * Math.min(1.0f, Math.max(0.0f, consumed)));
    }

    public int getBurnProgressPercent() {
        if (this.getBurnTimeTotal() <= 0) {
            return 0;
        }
        float consumed = (float)(this.getBurnTimeTotal() - this.getBurnTimeRemaining()) / (float)this.getBurnTimeTotal();
        return Math.max(0, Math.min(100, Math.round(consumed * 100.0f)));
    }

    public float getFuelProgress() {
        if (this.getBurnTimeTotal() <= 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)(this.getBurnTimeTotal() - this.getBurnTimeRemaining()) / (float)this.getBurnTimeTotal()), (float)0.0f, (float)1.0f);
    }

    public int getBurnSecondsRemaining() {
        return Math.max(0, this.getBurnTimeRemaining() / 20);
    }

    public int getBurnSecondsTotal() {
        return Math.max(0, this.getBurnTimeTotal() / 20);
    }

    public boolean hasColumnData() {
        return this.containerData.m_6413_(1) > 0;
    }

    @Override
    public boolean innerMovePlayer2Container(int index, ItemStack stack) {
        if (RBMKFuelChannelMenu.isFuelRod(stack)) {
            return this.m_38903_(stack, 0, 1, false);
        }
        return false;
    }

    private static RBMKFuelChannelEntity resolveFuelChannel(Inventory playerInventory, FriendlyByteBuf buf) {
        Objects.requireNonNull(buf, "buffer missing block position");
        BlockPos pos = buf.m_130135_();
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(pos);
        if (blockEntity instanceof RBMKFuelChannelEntity) {
            RBMKFuelChannelEntity entity = (RBMKFuelChannelEntity)blockEntity;
            return entity;
        }
        return null;
    }

    private static boolean isFuelRod(ItemStack stack) {
        return stack.m_41720_() instanceof ItemRBMKFuelRod;
    }
}

