/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.menu;

import com.hbm.blockentity.machine.WoodBurnerBlockEntity;
import com.hbm.gui.ModMenuType;
import com.hbm.gui.menu.BaseMachineMenu;
import com.hbm.gui.menu.slot.BatterySlot;
import com.hbm.gui.menu.slot.OutputSlot;
import com.hbm.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class WoodBurnerMenu
extends BaseMachineMenu {
    private final WoodBurnerBlockEntity blockEntity;
    private final Level level;
    private final BlockPos blockPos;

    public WoodBurnerMenu(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(containerId, playerInventory, WoodBurnerMenu.resolve(playerInventory, buf));
    }

    public WoodBurnerMenu(int containerId, Inventory playerInventory, WoodBurnerBlockEntity blockEntity, ContainerData data) {
        this(containerId, playerInventory, new Context(blockEntity, blockEntity != null ? blockEntity.m_58899_() : playerInventory.f_35978_.m_20183_()), blockEntity != null ? blockEntity.m_58904_() : playerInventory.f_35978_.m_9236_(), (ContainerData)(data != null ? data : new SimpleContainerData(7)));
    }

    private WoodBurnerMenu(int containerId, Inventory playerInventory, Context context) {
        this(containerId, playerInventory, context, playerInventory.f_35978_.m_9236_(), (ContainerData)new SimpleContainerData(7));
    }

    private WoodBurnerMenu(int containerId, Inventory playerInventory, Context context, Level level, ContainerData data) {
        super((MenuType)ModMenuType.WOOD_BURNER_MENU.get(), containerId, WoodBurnerMenu.resolveContainer(context), WoodBurnerMenu.resolveData(data));
        final WoodBurnerBlockEntity blockEntity = context.blockEntity();
        BlockPos pos = context.pos();
        this.blockEntity = blockEntity;
        this.level = level;
        this.blockPos = pos;
        this.slotNum = 3;
        this.m_38897_(new Slot(this.container, 0, 44, 53){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return blockEntity != null && blockEntity.m_7013_(0, stack);
            }
        });
        this.m_38897_(new OutputSlot(this.container, 1, 116, 53));
        this.m_38897_(new BatterySlot(this.container, 2, 80, 71));
        this.addPlayerSlot(playerInventory, 6, 16);
        this.m_38884_(this.containerData);
    }

    private static Context resolve(Inventory inventory, FriendlyByteBuf buf) {
        BlockEntity be;
        BlockPos pos = buf.m_130135_();
        WoodBurnerBlockEntity blockEntity = null;
        Level level = inventory.f_35978_.m_9236_();
        if (level != null && (be = level.m_7702_(pos)) instanceof WoodBurnerBlockEntity) {
            WoodBurnerBlockEntity wood;
            blockEntity = wood = (WoodBurnerBlockEntity)be;
        }
        return new Context(blockEntity, pos);
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0 && this.blockEntity != null && !player.m_9236_().f_46443_) {
            this.blockEntity.toggleEnabled();
            return true;
        }
        return super.m_6366_(player, id);
    }

    @Override
    public boolean m_6875_(@NotNull Player player) {
        return WoodBurnerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockPos), (Player)player, (Block)((Block)ModBlocks.machine_wood_burner.get()));
    }

    public int getBurnTimeScaled(int pixels) {
        int max = this.containerData.m_6413_(1);
        if (max <= 0) {
            return 0;
        }
        return Math.min(pixels, (int)((long)this.containerData.m_6413_(0) * (long)pixels / (long)max));
    }

    public int getEnergyScaled(int pixels) {
        long energy = this.getEnergyLong();
        long capacity = this.getMaxEnergyLong();
        if (capacity <= 0L) {
            return 0;
        }
        return (int)Math.min((long)pixels, energy * (long)pixels / capacity);
    }

    public long getEnergyLong() {
        long lo = Integer.toUnsignedLong(this.containerData.m_6413_(2));
        long hi = Integer.toUnsignedLong(this.containerData.m_6413_(3));
        return hi << 32 | lo;
    }

    public long getMaxEnergyLong() {
        long lo = Integer.toUnsignedLong(this.containerData.m_6413_(4));
        long hi = Integer.toUnsignedLong(this.containerData.m_6413_(5));
        return hi << 32 | lo;
    }

    public boolean isLit() {
        return this.containerData.m_6413_(0) > 0;
    }

    public boolean isEnabled() {
        return this.containerData.m_6413_(6) > 0;
    }

    public int getBurnTime() {
        return this.containerData.m_6413_(0);
    }

    public int getMaxBurnTime() {
        return this.containerData.m_6413_(1);
    }

    private static Container resolveContainer(Context context) {
        return context.blockEntity() != null ? context.blockEntity() : new SimpleContainer(3);
    }

    private static ContainerData resolveData(ContainerData data) {
        return data != null ? data : new SimpleContainerData(7);
    }

    private record Context(WoodBurnerBlockEntity blockEntity, BlockPos pos) {
    }
}

