/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.recipebook;

import com.hbm.gui.recipebook.HBMClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AssemblerBookComponent {
    protected static final ResourceLocation RECIPE_BOOK_LOCATION = new ResourceLocation("textures/gui/recipe_book.png");
    private int xOffset;
    private int width;
    private int height;
    private boolean visible;
    private boolean widthTooNarrow;
    private HBMClientRecipeBook book;
    private AbstractContainerMenu menu;
    private Minecraft minecraft;
    private final RecipeBookPage recipeBookPage = new RecipeBookPage();

    public void init(int pWidth, int pHeight, Minecraft pMinecraft, boolean widthTooNarrow, AbstractContainerMenu menu) {
        this.width = pWidth;
        this.height = pHeight;
        this.minecraft = pMinecraft;
        this.book = new HBMClientRecipeBook();
        this.visible = this.isVisibleAccordingToBookData();
        this.widthTooNarrow = widthTooNarrow;
        this.menu = menu;
    }

    public void initVisuals() {
        this.xOffset = this.widthTooNarrow ? 0 : 86;
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    protected void setVisible(boolean pVisible) {
        if (pVisible) {
            this.initVisuals();
        }
        this.visible = pVisible;
        this.book.m_12693_(null, pVisible);
        if (!pVisible) {
            this.recipeBookPage.m_100440_();
        }
        this.sendUpdateSettings();
    }

    protected void sendUpdateSettings() {
        if (this.minecraft.m_91403_() != null) {
            // empty if block
        }
    }

    public int updateScreenPosition(int pWidth, int pImageWidth) {
        int i = this.isVisible() && !this.widthTooNarrow ? 177 + (pWidth - pImageWidth - 200) / 2 : (pWidth - pImageWidth) / 2;
        return i;
    }

    public boolean isVisible() {
        return this.visible;
    }

    private boolean isVisibleAccordingToBookData() {
        return this.book.m_12691_(null);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.isVisible()) {
            pGuiGraphics.m_280168_().m_85836_();
            pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            int i = (this.width - 147) / 2 - this.xOffset;
            int j = (this.height - 166) / 2;
            pGuiGraphics.m_280218_(RECIPE_BOOK_LOCATION, i, j, 1, 1, 147, 166);
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    public void renderGhostRecipe(GuiGraphics pGuiGraphics, int pLeftPos, int pTopPos, boolean p_283495_, float pPartialTick) {
    }
}

