/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.screen;

import com.hbm.gui.menu.BaseMachineMenu;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public abstract class AbstractRBMKScreen<M extends BaseMachineMenu>
extends AbstractContainerScreen<M> {
    protected static final int STATE_X = 12;
    protected static final int STATE_Y = 28;
    protected static final int CONTROL_X = 168;
    protected static final int CONTROL_Y = 28;
    protected static final int ADVANCED_X = 12;
    protected static final int ADVANCED_Y = 132;
    protected static final int LINE_HEIGHT = 11;
    protected static final int SECTION_GAP = 6;
    protected static final int HEAT_COLOR = 0xFFAA33;
    protected static final int ENERGY_COLOR = 0x66FF66;
    protected static final int COOLANT_COLOR = 0x66CCFF;
    protected static final int STEAM_COLOR = 0xAAAADD;
    protected static final int SECTION_COLOR = 0xF0F0F0;
    protected boolean detailsVisible = false;
    private Button detailsToggle;

    protected AbstractRBMKScreen(M menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.enableAdvancedToggle()) {
            this.addDetailsToggle();
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        boolean hasData = this.hasColumnData();
        if (this.detailsToggle != null) {
            this.detailsToggle.f_93623_ = hasData;
            this.detailsToggle.f_93624_ = hasData;
        }
        this.updateInteractionState(hasData);
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        if (!this.hasColumnData()) {
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hbm.rbmk.no_column"), this.guiX(12), this.guiY(39), 0xFF5555, false);
            return;
        }
        RBMKReadings readings = this.primaryReadings();
        int y = this.drawSectionHeader(graphics, 12, 28, (Component)Component.m_237115_((String)"gui.hbm.rbmk.section.status"));
        this.drawStateSection(graphics, readings, 12, y);
        this.renderControlPanel(graphics, readings);
        this.renderAdvancedPanel(graphics, readings);
    }

    private void addDetailsToggle() {
        int buttonX = this.guiX(12);
        int buttonY = this.guiY(114);
        this.detailsToggle = Button.m_253074_((Component)this.getDetailsLabel(), b -> this.toggleDetails()).m_252987_(buttonX, buttonY, 102, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.detailsToggle);
    }

    private void toggleDetails() {
        boolean bl = this.detailsVisible = !this.detailsVisible;
        if (this.detailsToggle != null) {
            this.detailsToggle.m_93666_(this.getDetailsLabel());
        }
    }

    private Component getDetailsLabel() {
        return Component.m_237115_((String)(this.detailsVisible ? "gui.hbm.rbmk.details.hide" : "gui.hbm.rbmk.details.show"));
    }

    private void renderAdvancedPanel(GuiGraphics graphics, RBMKReadings readings) {
        int y = this.drawSectionHeader(graphics, 12, 132, (Component)Component.m_237115_((String)"gui.hbm.rbmk.section.advanced"));
        if (!this.detailsVisible) {
            return;
        }
        this.drawAdvancedContent(graphics, readings, 16, y);
    }

    protected void drawStateSection(GuiGraphics graphics, RBMKReadings readings, int x, int y) {
        ReactorStatus status = this.resolveStatus(readings);
        y = this.drawValueLine(graphics, x, y, (Component)Component.m_237110_((String)"gui.hbm.rbmk.status", (Object[])new Object[]{Component.m_237115_((String)status.translationKey())}), status.color());
        y = this.drawValueLine(graphics, x, y, (Component)Component.m_237110_((String)"gui.hbm.rbmk.heat", (Object[])new Object[]{AbstractRBMKScreen.formatOneDecimal(readings.heat()), AbstractRBMKScreen.formatOneDecimal(readings.meltdownThreshold())}), 0xFFAA33);
        y = this.drawValueLine(graphics, x, y, (Component)Component.m_237110_((String)"gui.hbm.rbmk.energy", (Object[])new Object[]{readings.energyStored(), readings.energyCapacity()}), 0x66FF66);
        y = this.drawValueLine(graphics, x, y, (Component)Component.m_237110_((String)"gui.hbm.rbmk.coolant", (Object[])new Object[]{readings.coolantMb()}), 0x66CCFF);
        this.drawValueLine(graphics, x, y, (Component)Component.m_237110_((String)"gui.hbm.rbmk.steam", (Object[])new Object[]{readings.steamMb()}), 0xAAAADD);
    }

    protected int drawSectionHeader(GuiGraphics graphics, int x, int y, Component text) {
        graphics.m_280614_(this.f_96547_, text, this.guiX(x), this.guiY(y), 0xF0F0F0, false);
        return y + 11;
    }

    protected int drawValueLine(GuiGraphics graphics, int x, int y, Component text, int color) {
        graphics.m_280614_(this.f_96547_, text, this.guiX(x), this.guiY(y), color, false);
        return y + 11;
    }

    protected static String formatOneDecimal(float value) {
        return String.format(Locale.ROOT, "%.1f", Float.valueOf(value));
    }

    protected ReactorStatus resolveStatus(RBMKReadings readings) {
        if (readings.meltdownThreshold() <= 0.0f) {
            return ReactorStatus.OFFLINE;
        }
        float ratio = readings.heat() / readings.meltdownThreshold();
        if (ratio >= 0.9f) {
            return ReactorStatus.CRITICAL;
        }
        if (ratio >= 0.7f) {
            return ReactorStatus.WARNING;
        }
        if (readings.energyStored() > 0 || readings.steamMb() > 0) {
            return ReactorStatus.RUNNING;
        }
        return ReactorStatus.OFFLINE;
    }

    private void drawAdvancedContent(GuiGraphics graphics, RBMKReadings readings, int x, int startY) {
        this.renderAdvancedDetails(graphics, readings, x, startY);
    }

    protected int guiX(int localX) {
        return this.f_97735_ + localX;
    }

    protected int guiY(int localY) {
        return this.f_97736_ + localY;
    }

    protected abstract boolean hasColumnData();

    protected abstract RBMKReadings primaryReadings();

    protected abstract void renderControlPanel(GuiGraphics var1, RBMKReadings var2);

    protected abstract void renderAdvancedDetails(GuiGraphics var1, RBMKReadings var2, int var3, int var4);

    protected abstract void updateInteractionState(boolean var1);

    protected boolean enableAdvancedToggle() {
        return true;
    }

    protected Component recommendAction(RBMKReadings readings, int localControlPercent, int globalControlPercent) {
        if (readings.coolantMb() < 2000) {
            return Component.m_237115_((String)"gui.hbm.rbmk.action.coolant");
        }
        if (readings.energyCapacity() > 0 && readings.energyStored() >= readings.energyCapacity()) {
            return Component.m_237115_((String)"gui.hbm.rbmk.action.dump_power");
        }
        ReactorStatus status = this.resolveStatus(readings);
        if (status == ReactorStatus.CRITICAL || status == ReactorStatus.WARNING) {
            return Component.m_237115_((String)"gui.hbm.rbmk.action.insert_rods");
        }
        if (localControlPercent >= 95 && readings.heat() < readings.meltdownThreshold() * 0.3f) {
            return Component.m_237115_((String)"gui.hbm.rbmk.action.raise_rods");
        }
        return Component.m_237115_((String)"gui.hbm.rbmk.action.normal");
    }

    protected record RBMKReadings(float heat, float meltdownThreshold, int energyStored, int energyCapacity, int coolantMb, int steamMb) {
    }

    protected static enum ReactorStatus {
        OFFLINE("gui.hbm.rbmk.status.offline", 0x979797),
        RUNNING("gui.hbm.rbmk.status.running", 8313175),
        WARNING("gui.hbm.rbmk.status.warning", 16765286),
        CRITICAL("gui.hbm.rbmk.status.critical", 0xFF5555);

        private final String translationKey;
        private final int color;

        private ReactorStatus(String translationKey, int color) {
            this.translationKey = translationKey;
            this.color = color;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public int color() {
            return this.color;
        }
    }
}

