/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.screen;

import com.hbm.HBM;
import com.hbm.blockentity.machine.GasTurbineBlockEntity;
import com.hbm.gui.menu.GasTurbineMenu;
import com.hbm.gui.screen.BaseMachineGui;
import com.hbm.gui.screen.component.BarFluid;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GasTurbineScreen
extends BaseMachineGui<GasTurbineMenu> {
    private static final ResourceLocation TEXTURE = HBM.rl("textures/gui/generators/gui_turbinegas.png");
    private static final ResourceLocation GAUGE_TEXTURE = HBM.rl("textures/gui/gauges/button_big.png");
    private static final int SLIDER_X = 36;
    private static final int SLIDER_Y = 37;
    private static final int SLIDER_WIDTH = 16;
    private static final int SLIDER_HEIGHT = 66;
    private final List<BarFluid> fluidBars = new ArrayList<BarFluid>(4);
    private boolean draggingSlider;

    public GasTurbineScreen(GasTurbineMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 223;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.fluidBars.clear();
        this.fluidBars.add(new BarFluid(() -> this.f_97735_ + 8, () -> this.f_97736_ + 65, 16, 48, Fluids.f_76191_));
        this.fluidBars.add(new BarFluid(() -> this.f_97735_ + 8, () -> this.f_97736_ + 103, 16, 32, Fluids.f_76191_));
        this.fluidBars.add(new BarFluid(() -> this.f_97735_ + 147, () -> this.f_97736_ + 98, 16, 36, Fluids.f_76191_));
        this.fluidBars.add(new BarFluid(() -> this.f_97735_ + 147, () -> this.f_97736_ + 58, 16, 36, Fluids.f_76191_));
        this.fluidBars.forEach(bar -> {
            bar.f_93623_ = false;
            bar.f_93624_ = true;
            this.m_142416_((GuiEventListener)bar);
        });
    }

    protected void m_181908_() {
        List<FluidTank> tanks;
        super.m_181908_();
        GasTurbineBlockEntity entity = ((GasTurbineMenu)this.f_97732_).getBlockEntity();
        if (entity != null && (tanks = entity.getFluids().getFluidTanks()).size() >= 4) {
            GasTurbineScreen.updateBar(this.fluidBars.get(0), tanks.get(0));
            GasTurbineScreen.updateBar(this.fluidBars.get(1), tanks.get(1));
            GasTurbineScreen.updateBar(this.fluidBars.get(2), tanks.get(2));
            GasTurbineScreen.updateBar(this.fluidBars.get(3), tanks.get(3));
        }
    }

    private static void updateBar(BarFluid bar, FluidTank tank) {
        bar.fluid = tank.getFluid().getFluid();
        bar.progress = tank.getFluidAmount();
        bar.maxProgress = tank.getCapacity();
        bar.updateData();
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.drawAutoButton(graphics);
        this.drawStateButton(graphics);
        this.drawSlider(graphics);
        this.drawEnergyBar(graphics);
        this.drawPowerDisplay(graphics);
        this.drawThermometer(graphics);
        this.drawRpmGauge(graphics);
    }

    private void drawAutoButton(GuiGraphics graphics) {
        int v = ((GasTurbineMenu)this.f_97732_).isAutoMode() && ((GasTurbineMenu)this.f_97732_).isRunning() ? 11 : 24;
        graphics.m_280218_(TEXTURE, this.f_97735_ + 74, this.f_97736_ + 86, 194, v, 29, 13);
    }

    private void drawStateButton(GuiGraphics graphics) {
        int state = ((GasTurbineMenu)this.f_97732_).getState();
        int u = switch (state) {
            case -1 -> 194;
            case 1 -> 210;
            default -> 178;
        };
        graphics.m_280218_(TEXTURE, this.f_97735_ + 80, this.f_97736_ + 32, u, 38, 16, 16);
    }

    private void drawSlider(GuiGraphics graphics) {
        graphics.m_280218_(TEXTURE, this.f_97735_ + 36, this.f_97736_ + 97 - ((GasTurbineMenu)this.f_97732_).getSliderPosition(), 178, 0, 16, 6);
    }

    private void drawEnergyBar(GuiGraphics graphics) {
        long energy = ((GasTurbineMenu)this.f_97732_).getEnergy();
        int width = (int)Math.min(142L, energy * 142L / 1000000L);
        if (width > 0) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 26, this.f_97736_ + 109, 0, 223, width, 16);
        }
    }

    private void drawPowerDisplay(GuiGraphics graphics) {
        int i;
        int display = ((GasTurbineMenu)this.f_97732_).getState() == -1 ? 8888888 : Math.max(0, ((GasTurbineMenu)this.f_97732_).getInstantPowerOutput() * 20);
        int[] digits = new int[7];
        int value = display;
        for (int i2 = 6; i2 >= 0; --i2) {
            digits[i2] = value % 10;
            value /= 10;
            graphics.m_280218_(TEXTURE, this.f_97735_ + 65 + i2 * 7, this.f_97736_ + 71, 194 + digits[i2] * 5, 0, 5, 11);
        }
        int firstNonZero = -1;
        for (i = 0; i < digits.length; ++i) {
            if (digits[i] == 0) continue;
            firstNonZero = i;
            break;
        }
        if (firstNonZero == -1) {
            firstNonZero = digits.length - 1;
        }
        for (i = 0; i < firstNonZero; ++i) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 65 + i * 7, this.f_97736_ + 71, 244, 0, 5, 11);
        }
    }

    private void drawThermometer(GuiGraphics graphics) {
        int maxTemp = 800;
        int temp = Mth.m_14045_((int)((GasTurbineMenu)this.f_97732_).getTemperature(), (int)0, (int)maxTemp);
        int filled = (int)Math.round(64.0 * (double)temp / (double)maxTemp);
        if (filled > 0) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 136, this.f_97736_ + 28 + 64 - filled, 176, 64 - filled, 2, filled);
        }
    }

    private void drawRpmGauge(GuiGraphics graphics) {
        int rpm = Mth.m_14045_((int)((GasTurbineMenu)this.f_97732_).getRpm(), (int)0, (int)100);
        graphics.m_280163_(GAUGE_TEXTURE, this.f_97735_ + 64, this.f_97736_ + 16, (float)(rpm * 48), 0.0f, 48, 48, 4848, 48);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isInsideStartButton(mouseX, mouseY)) {
                this.sendButton(0);
                return true;
            }
            if (((GasTurbineMenu)this.f_97732_).isRunning() && this.isInsideAutoButton(mouseX, mouseY)) {
                this.sendButton(1);
                return true;
            }
            if (((GasTurbineMenu)this.f_97732_).isRunning() && this.isInsideSlider(mouseX, mouseY)) {
                this.draggingSlider = true;
                this.sendSlider(mouseY);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingSlider) {
            if (((GasTurbineMenu)this.f_97732_).isRunning()) {
                this.sendSlider(mouseY);
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.draggingSlider) {
            this.draggingSlider = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void sendButton(int id) {
        if (this.f_96541_ != null && this.f_96541_.f_91072_ != null) {
            this.f_96541_.f_91072_.m_105208_(((GasTurbineMenu)this.f_97732_).f_38840_, id);
        }
    }

    private void sendSlider(double mouseY) {
        if (this.f_96541_ == null || this.f_96541_.f_91072_ == null || !((GasTurbineMenu)this.f_97732_).isRunning()) {
            return;
        }
        int value = this.computeSliderValue(mouseY);
        this.f_96541_.f_91072_.m_105208_(((GasTurbineMenu)this.f_97732_).f_38840_, GasTurbineMenu.sliderButtonId(value));
    }

    private int computeSliderValue(double mouseY) {
        double localY = mouseY - (double)this.f_97736_;
        int slider = (int)Math.round(97.0 - localY);
        return Mth.m_14045_((int)slider, (int)0, (int)60);
    }

    private boolean isInsideSlider(double mouseX, double mouseY) {
        return this.isInside(mouseX, mouseY, 36, 37, 16, 66);
    }

    private boolean isInsideStartButton(double mouseX, double mouseY) {
        double centerX = this.f_97735_ + 88;
        double dx = mouseX - centerX;
        double centerY = this.f_97736_ + 40;
        double dy = mouseY - centerY;
        return dx * dx + dy * dy <= 64.0;
    }

    private boolean isInsideAutoButton(double mouseX, double mouseY) {
        return this.isInside(mouseX, mouseY, 74, 86, 29, 13);
    }

    private boolean isInside(double mouseX, double mouseY, int x, int y, int width, int height) {
        int relX = this.f_97735_ + x;
        int relY = this.f_97736_ + y;
        return mouseX >= (double)relX && mouseX < (double)(relX + width) && mouseY >= (double)relY && mouseY < (double)(relY + height);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        if (this.isInside(mouseX, mouseY, 26, 109, 142, 16)) {
            List<MutableComponent> energyTip = List.of(Component.m_237113_((String)String.format(Locale.ROOT, "%,d / %,d HE", ((GasTurbineMenu)this.f_97732_).getEnergy(), 1000000L)).m_130940_(ChatFormatting.GREEN));
            graphics.m_280666_(this.f_96547_, energyTip, mouseX, mouseY);
        }
        if (this.isInsideSlider(mouseX, mouseY)) {
            List<MutableComponent> sliderTip = List.of(Component.m_237113_((String)("Throttle: " + ((GasTurbineMenu)this.f_97732_).getThrottle() + "%")).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)(((GasTurbineMenu)this.f_97732_).isAutoMode() ? "Auto Mode: ON" : "Auto Mode: OFF")).m_130940_(((GasTurbineMenu)this.f_97732_).isAutoMode() ? ChatFormatting.AQUA : ChatFormatting.GRAY));
            graphics.m_280666_(this.f_96547_, sliderTip, mouseX, mouseY);
        }
        if (this.isInsideAutoButton(mouseX, mouseY)) {
            MutableComponent auto = Component.m_237113_((String)(((GasTurbineMenu)this.f_97732_).isAutoMode() ? "Auto Mode Enabled" : "Auto Mode Disabled")).m_130940_(((GasTurbineMenu)this.f_97732_).isAutoMode() ? ChatFormatting.GREEN : ChatFormatting.RED);
            graphics.m_280557_(this.f_96547_, (Component)auto, mouseX, mouseY);
        }
        if (this.isInsideStartButton(mouseX, mouseY)) {
            MutableComponent status = Component.m_237113_((String)(((GasTurbineMenu)this.f_97732_).getState() == 0 ? "Start Turbine" : "Stop Turbine")).m_130940_(ChatFormatting.YELLOW);
            graphics.m_280557_(this.f_96547_, (Component)status, mouseX, mouseY);
        }
    }
}

