/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.screen;

import com.hbm.HBM;
import com.hbm.gui.menu.PWRMenu;
import com.hbm.gui.screen.BaseMachineGui;
import com.hbm.item.HBMItems;
import com.hbm.item.pwr.ItemPWRFuel;
import com.hbm.reactor.pwr.PWRFuelType;
import com.hbm.render.utils.GaugeUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PWRScreen
extends BaseMachineGui<PWRMenu> {
    private static final ResourceLocation TEXTURE = HBM.rl("textures/gui/reactors/gui_pwr.png");
    private static final ResourceLocation COOLANT_TEXTURE = HBM.rl("textures/gui/fluids/coolant.png");
    private static final ResourceLocation HOT_COOLANT_TEXTURE = HBM.rl("textures/gui/fluids/coolant_hot.png");
    private EditBox rodField;

    public PWRScreen(PWRMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 188;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.rodField = new EditBox(this.f_96547_, this.f_97735_ + 57, this.f_97736_ + 63, 30, 8, (Component)Component.m_237119_());
        this.rodField.m_94182_(false);
        this.rodField.m_94202_(65280);
        this.rodField.m_94199_(3);
        this.rodField.m_94144_(String.valueOf(this.getRodTargetDisplay()));
        this.m_142416_((GuiEventListener)this.rodField);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.rodField.m_94120_();
        if (!this.rodField.m_93696_()) {
            this.rodField.m_94144_(String.valueOf(this.getRodTargetDisplay()));
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderCustomTooltips(graphics, mouseX, mouseY);
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        double rodLevel;
        int rodWidth;
        int barWidth;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int coreHeat = ((PWRMenu)this.f_97732_).getCoreHeat();
        int coreCap = ((PWRMenu)this.f_97732_).getCoreHeatCapacity();
        int hullHeat = ((PWRMenu)this.f_97732_).getHullHeat();
        int hullCap = ((PWRMenu)this.f_97732_).getHullHeatCapacity();
        if (coreCap > 0 && (float)coreHeat > (float)coreCap * 0.8f || hullCap > 0 && (float)hullHeat > (float)hullCap * 0.8f) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 147, this.f_97736_, 176, 14, 26, 26);
        }
        int processTime = ((PWRMenu)this.f_97732_).getProcessTime();
        int progress = ((PWRMenu)this.f_97732_).getProgress();
        int n = barWidth = processTime > 0 ? (int)((double)progress * 33.0 / (double)processTime) : 0;
        if (barWidth > 0) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 54, this.f_97736_ + 33, 176, 0, barWidth, 14);
        }
        if ((rodWidth = (int)((rodLevel = this.getRodLevel()) * 52.0 / 100.0)) > 0) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 53, this.f_97736_ + 54, 176, 40, rodWidth, 2);
        }
        double coreRatio = coreCap > 0 ? (double)coreHeat / (double)coreCap : 0.0;
        double hullRatio = hullCap > 0 ? (double)hullHeat / (double)hullCap : 0.0;
        GaugeUtil.drawSmoothGauge(graphics, this.f_97735_ + 124, this.f_97736_ + 40, 0.0f, coreRatio, 5.0, 2.0, 1.0, 0x7F0000, 0);
        GaugeUtil.drawSmoothGauge(graphics, this.f_97735_ + 160, this.f_97736_ + 40, 0.0f, hullRatio, 5.0, 2.0, 1.0, 0x7F0000, 0);
        int fuelTypeIndex = ((PWRMenu)this.f_97732_).getFuelType();
        int amountLoaded = ((PWRMenu)this.f_97732_).getFuelAmount();
        int rodCount = ((PWRMenu)this.f_97732_).getRodCount();
        if (fuelTypeIndex >= 0 && amountLoaded > 0) {
            PWRFuelType fuel = PWRFuelType.fromIndex(fuelTypeIndex);
            ItemStack display = ItemPWRFuel.createStack((Item)HBMItems.pwr_fuel.get(), fuel);
            graphics.m_280480_(display, this.f_97735_ + 89, this.f_97736_ + 5);
            graphics.m_280302_(this.f_96547_, display, this.f_97735_ + 89, this.f_97736_ + 5, String.format(Locale.ROOT, "%d/%d", amountLoaded, rodCount));
        }
        this.drawFluid(graphics, COOLANT_TEXTURE, this.f_97735_ + 8, this.f_97736_ + 57, 16, 52, ((PWRMenu)this.f_97732_).getCoolantAmount(), 128000);
        this.drawFluid(graphics, HOT_COOLANT_TEXTURE, this.f_97735_ + 26, this.f_97736_ + 57, 16, 52, ((PWRMenu)this.f_97732_).getHotCoolantAmount(), 128000);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        double flux = (double)((PWRMenu)this.f_97732_).getFluxScaled() / 10.0;
        String fluxText = String.format(Locale.ROOT, "%,.1f", flux);
        float scale = 1.25f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(1.0f / scale, 1.0f / scale, 1.0f);
        int x = (int)(165.0f * scale - (float)this.f_96547_.m_92895_(fluxText));
        int y = (int)(64.0f * scale);
        graphics.m_280056_(this.f_96547_, fluxText, x, y, 65280, false);
        graphics.m_280168_().m_85849_();
    }

    private void renderCustomTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        int guiLeft = this.f_97735_;
        int guiTop = this.f_97736_;
        int coreHeat = ((PWRMenu)this.f_97732_).getCoreHeat();
        int coreCap = ((PWRMenu)this.f_97732_).getCoreHeatCapacity();
        int hullHeat = ((PWRMenu)this.f_97732_).getHullHeat();
        int hullCap = ((PWRMenu)this.f_97732_).getHullHeatCapacity();
        this.drawCustomInfoStat(graphics, mouseX, mouseY, guiLeft + 115, guiTop + 31, 18, 18, List.of(Component.m_237113_((String)("Core: " + String.format(Locale.ROOT, "%,d", coreHeat) + " / " + String.format(Locale.ROOT, "%,d", coreCap) + " TU"))));
        this.drawCustomInfoStat(graphics, mouseX, mouseY, guiLeft + 151, guiTop + 31, 18, 18, List.of(Component.m_237113_((String)("Hull: " + String.format(Locale.ROOT, "%,d", hullHeat) + " / " + String.format(Locale.ROOT, "%,d", hullCap) + " TU"))));
        int processTime = ((PWRMenu)this.f_97732_).getProcessTime();
        int progress = ((PWRMenu)this.f_97732_).getProgress();
        int percent = processTime > 0 ? (int)((double)progress * 100.0 / (double)processTime) : 0;
        this.drawCustomInfoStat(graphics, mouseX, mouseY, guiLeft + 52, guiTop + 31, 36, 18, List.of(Component.m_237113_((String)(percent + "%"))));
        double rodLevel = this.getRodLevel();
        this.drawCustomInfoStat(graphics, mouseX, mouseY, guiLeft + 52, guiTop + 53, 54, 4, List.of(Component.m_237113_((String)("Control rod level: " + (100.0 - (double)Math.round(rodLevel * 100.0) / 100.0) + "%"))));
        int fuelTypeIndex = ((PWRMenu)this.f_97732_).getFuelType();
        int amountLoaded = ((PWRMenu)this.f_97732_).getFuelAmount();
        if (fuelTypeIndex >= 0 && amountLoaded > 0) {
            int fx = guiLeft + 88;
            int fy = guiTop + 4;
            if (mouseX >= fx && mouseX < fx + 18 && mouseY >= fy && mouseY < fy + 18) {
                PWRFuelType fuel = PWRFuelType.fromIndex(fuelTypeIndex);
                ItemStack display = ItemPWRFuel.createStack((Item)HBMItems.pwr_fuel.get(), fuel);
                graphics.m_280153_(this.f_96547_, display, mouseX, mouseY);
            }
        }
    }

    private void drawFluid(GuiGraphics graphics, ResourceLocation texture, int x, int y, int width, int height, int amount, int capacity) {
        int drawHeight;
        if (capacity <= 0 || amount <= 0) {
            return;
        }
        float ratio = Mth.m_14036_((float)((float)amount / (float)capacity), (float)0.0f, (float)1.0f);
        int renderHeight = (int)((float)height * ratio);
        int startY = y + height - renderHeight;
        int drawY = startY;
        for (int remaining = renderHeight; remaining > 0; remaining -= drawHeight) {
            drawHeight = Math.min(16, remaining);
            graphics.m_280163_(texture, x, drawY, 0.0f, (float)(16 - drawHeight), width, drawHeight, 16, 16);
            drawY += drawHeight;
        }
    }

    private int getRodTargetDisplay() {
        int target = (int)Math.round((double)((PWRMenu)this.f_97732_).getRodTargetScaled() / 100.0);
        return Mth.m_14045_((int)(100 - target), (int)0, (int)100);
    }

    private double getRodLevel() {
        return (double)((PWRMenu)this.f_97732_).getRodLevelScaled() / 100.0;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handled = super.m_6375_(mouseX, mouseY, button);
        this.rodField.m_6375_(mouseX, mouseY, button);
        if (button == 0) {
            int bx = this.f_97735_ + 88;
            int by = this.f_97736_ + 58;
            if (mouseX >= (double)bx && mouseX < (double)(bx + 18) && mouseY >= (double)by && mouseY < (double)(by + 18)) {
                int level = this.parseRodField();
                int target = 100 - level;
                this.sendMenuButton(target);
                return true;
            }
        }
        return handled;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.rodField.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.rodField.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private int parseRodField() {
        String text = this.rodField.m_94155_();
        int level = 0;
        try {
            level = Integer.parseInt(text.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        level = Mth.m_14045_((int)level, (int)0, (int)100);
        this.rodField.m_94144_(String.valueOf(level));
        return level;
    }

    private void sendMenuButton(int id) {
        if (this.f_96541_ != null && this.f_96541_.f_91072_ != null) {
            this.f_96541_.f_91072_.m_105208_(((PWRMenu)this.f_97732_).f_38840_, id);
        }
    }
}

