/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.screen;

import com.hbm.HBM;
import com.hbm.gui.menu.ResearchReactorMenu;
import com.hbm.gui.screen.BaseMachineGui;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;

public class ResearchReactorScreen
extends BaseMachineGui<ResearchReactorMenu> {
    private static final ResourceLocation TEXTURE = HBM.rl("textures/gui/reactors/gui_research_reactor.png");
    private EditBox controlField;
    private int confirmationTimer;

    public ResearchReactorScreen(ResearchReactorMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.controlField = new EditBox(this.f_96547_, this.f_97735_ + 8, this.f_97736_ + 99, 33, 16, (Component)Component.m_237119_());
        this.controlField.m_94144_(String.valueOf(((ResearchReactorMenu)this.f_97732_).getTargetPercent()));
        this.controlField.m_94182_(false);
        this.controlField.m_94199_(3);
        this.controlField.m_94202_(589568);
        this.m_142416_((GuiEventListener)this.controlField);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.controlField.m_94120_();
        if (!this.controlField.m_93696_()) {
            this.controlField.m_94144_(String.valueOf(((ResearchReactorMenu)this.f_97732_).getTargetPercent()));
        }
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((ResearchReactorMenu)this.f_97732_).getControlPercent() <= 50) {
            int y;
            int x;
            for (x = 0; x < 3; ++x) {
                for (y = 0; y < 3; ++y) {
                    graphics.m_280218_(TEXTURE, this.f_97735_ + 81 + 36 * x, this.f_97736_ + 26 + 36 * y, 176, 0, 8, 8);
                }
            }
            for (x = 0; x < 2; ++x) {
                for (y = 0; y < 2; ++y) {
                    graphics.m_280218_(TEXTURE, this.f_97735_ + 99 + 36 * x, this.f_97736_ + 44 + 36 * y, 176, 0, 8, 8);
                }
            }
        }
        if (this.confirmationTimer > 0) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 44, this.f_97736_ + 97, 176, 8, 11, 20);
            --this.confirmationTimer;
        }
        String flux = String.format(Locale.ROOT, "%04d", ((ResearchReactorMenu)this.f_97732_).getFlux());
        graphics.m_280056_(this.f_96547_, flux, this.f_97735_ + 6, this.f_97736_ + 24, 589568, false);
        int temp = (int)Math.round((double)((ResearchReactorMenu)this.f_97732_).getHeat() * 2.0E-5 * 980.0 + 20.0);
        graphics.m_280056_(this.f_96547_, temp + "\u00b0C", this.f_97735_ + 6, this.f_97736_ + 62, 589568, false);
        graphics.m_280056_(this.f_96547_, ((ResearchReactorMenu)this.f_97732_).getControlPercent() + "%", this.f_97735_ + 6, this.f_97736_ + 100, 589568, false);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handled = super.m_6375_(mouseX, mouseY, button);
        this.controlField.m_6375_(mouseX, mouseY, button);
        if (button == 0 && this.isWithinConfirm(mouseX, mouseY)) {
            this.sendControlUpdate();
            this.confirmationTimer = 15;
            return true;
        }
        return handled;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.controlField.m_7933_(keyCode, scanCode, modifiers) || this.controlField.m_94204_()) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.controlField.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private boolean isWithinConfirm(double mouseX, double mouseY) {
        return mouseX >= (double)(this.f_97735_ + 44) && mouseX < (double)(this.f_97735_ + 55) && mouseY >= (double)(this.f_97736_ + 97) && mouseY < (double)(this.f_97736_ + 117);
    }

    private void sendControlUpdate() {
        if (this.f_96541_ == null || this.f_96541_.f_91072_ == null) {
            return;
        }
        int value = ResearchReactorScreen.parsePercentage(this.controlField.m_94155_());
        this.controlField.m_94144_(Integer.toString(value));
        this.f_96541_.f_91072_.m_105208_(((ResearchReactorMenu)this.f_97732_).f_38840_, 1000 + value);
    }

    private static int parsePercentage(String text) {
        try {
            return Mth.m_14045_((int)Integer.parseInt(text), (int)0, (int)100);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String value = this.controlField != null ? this.controlField.m_94155_() : "0";
        super.m_6574_(minecraft, width, height);
        this.controlField.m_94144_(value);
    }
}

