/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.screen;

import com.hbm.HBMLang;
import com.hbm.gui.menu.ShredderMenu;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ShredderGui
extends AbstractContainerScreen<ShredderMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("hbm", "textures/gui/gui_shredder.png");
    private static final int ENERGY_BAR_HEIGHT = 88;

    public ShredderGui(ShredderMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 233;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97731_ = this.f_97727_ - 96 + 2;
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int bar;
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int energyStored = ((ShredderMenu)this.f_97732_).getEnergyStored();
        int energyCapacity = Math.max(((ShredderMenu)this.f_97732_).getEnergyCapacity(), 1);
        if (energyStored > 0 && (bar = (int)Math.ceil((double)energyStored / (double)energyCapacity * 88.0)) > 0) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 8, this.f_97736_ + 106 - bar, 176, 160 - bar, 16, bar);
        }
        int maxProgress = Math.max(((ShredderMenu)this.f_97732_).getMaxProgress(), 1);
        if (((ShredderMenu)this.f_97732_).getProgress() > 0) {
            int bar2 = (int)Math.ceil((double)((ShredderMenu)this.f_97732_).getProgress() / (double)maxProgress * 34.0);
            graphics.m_280218_(TEXTURE, this.f_97735_ + 63, this.f_97736_ + 89, 176, 54, Math.min(bar2, 34) + 1, 18);
        }
        this.renderBladeState(graphics, ((ShredderMenu)this.f_97732_).getLeftBladeState(), true);
        this.renderBladeState(graphics, ((ShredderMenu)this.f_97732_).getRightBladeState(), false);
        if (this.hasBladeIssue()) {
            graphics.m_280509_(this.f_97735_ - 16, this.f_97736_ + 36, this.f_97735_, this.f_97736_ + 52, -1593901056);
        }
    }

    private void renderBladeState(GuiGraphics graphics, int state, boolean left) {
        if (state <= 0) {
            return;
        }
        int u = left ? 176 : 194;
        int v = switch (state) {
            case 1 -> 0;
            case 2 -> 18;
            default -> 36;
        };
        int x = left ? this.f_97735_ + 43 : this.f_97735_ + 79;
        graphics.m_280218_(TEXTURE, x, this.f_97736_ + 71, u, v, 18, 18);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
        if (this.isHoveringEnergy(mouseX, mouseY)) {
            tooltips.add(Component.m_237110_((String)HBMLang.TOOLTIP_ENERGY.key(), (Object[])new Object[]{((ShredderMenu)this.f_97732_).getEnergyStored(), ((ShredderMenu)this.f_97732_).getEnergyCapacity()}));
        }
        if (this.hasBladeIssue() && this.isHoveringWarning(mouseX, mouseY)) {
            tooltips.add(Component.m_237115_((String)"gui.hbm.shredder.no_blade"));
        }
        if (!tooltips.isEmpty()) {
            graphics.m_280666_(this.f_96547_, tooltips, mouseX, mouseY);
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private boolean isHoveringEnergy(int mouseX, int mouseY) {
        int x = this.f_97735_ + 8;
        int y = this.f_97736_ + 18;
        return mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 88;
    }

    private boolean isHoveringWarning(int mouseX, int mouseY) {
        int x = this.f_97735_ - 16;
        int y = this.f_97736_ + 36;
        return mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16;
    }

    private boolean hasBladeIssue() {
        return ((ShredderMenu)this.f_97732_).getLeftBladeState() == 0 || ((ShredderMenu)this.f_97732_).getLeftBladeState() == 3 || ((ShredderMenu)this.f_97732_).getRightBladeState() == 0 || ((ShredderMenu)this.f_97732_).getRightBladeState() == 3;
    }
}

