/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.screen;

import com.hbm.HBM;
import com.hbm.gui.menu.ZirnoxMenu;
import com.hbm.gui.screen.BaseMachineGui;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;

public class ZirnoxScreen
extends BaseMachineGui<ZirnoxMenu> {
    private static final ResourceLocation TEXTURE = HBM.rl("textures/gui/reactors/gui_zirnox.png");

    public ZirnoxScreen(ZirnoxMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.f_97726_ = 203;
        this.f_97727_ = 256;
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int steam = ((ZirnoxMenu)this.f_97732_).getSteam();
        int co2 = ((ZirnoxMenu)this.f_97732_).getCarbonDioxide();
        int water = ((ZirnoxMenu)this.f_97732_).getWater();
        int heat = ((ZirnoxMenu)this.f_97732_).getHeat();
        int pressure = ((ZirnoxMenu)this.f_97732_).getPressure();
        int steamGauge = ZirnoxScreen.scale(steam, 8000, 6);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 160, this.f_97736_ + 108, 238, 12 * steamGauge, 18, 12);
        int co2Gauge = ZirnoxScreen.scale(co2, 16000, 6);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 142, this.f_97736_ + 108, 238, 12 * co2Gauge, 18, 12);
        int waterGauge = ZirnoxScreen.scale(water, 32000, 6);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 178, this.f_97736_ + 108, 238, 12 * waterGauge, 18, 12);
        int heatGauge = ZirnoxScreen.scale(heat, 100000, 12);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 160, this.f_97736_ + 33, 220, 18 * heatGauge, 18, 17);
        int pressureGauge = ZirnoxScreen.scale(pressure, 100000, 12);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 178, this.f_97736_ + 33, 220, 18 * pressureGauge, 18, 17);
        if (((ZirnoxMenu)this.f_97732_).isOn()) {
            int y;
            int x;
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 4; ++y) {
                    graphics.m_280218_(TEXTURE, this.f_97735_ + 7 + 36 * x, this.f_97736_ + 15 + 36 * y, 238, 238, 18, 18);
                }
            }
            for (x = 0; x < 3; ++x) {
                for (y = 0; y < 3; ++y) {
                    graphics.m_280218_(TEXTURE, this.f_97735_ + 25 + 36 * x, this.f_97736_ + 33 + 36 * y, 238, 238, 18, 18);
                }
            }
            graphics.m_280218_(TEXTURE, this.f_97735_ + 142, this.f_97736_ + 15, 220, 238, 18, 18);
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderCustomTooltips(graphics, mouseX, mouseY);
    }

    private void renderCustomTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        int temp = (int)Math.round((double)((ZirnoxMenu)this.f_97732_).getHeat() * 1.0E-5 * 780.0 + 20.0);
        int pressureBar = (int)Math.round((double)((ZirnoxMenu)this.f_97732_).getPressure() * 1.0E-5 * 30.0);
        this.drawCustomInfoStat(graphics, mouseX, mouseY, this.f_97735_ + 160, this.f_97736_ + 33, 18, 17, List.of(Component.m_237113_((String)("Temperature: " + temp + "\u00b0C"))));
        this.drawCustomInfoStat(graphics, mouseX, mouseY, this.f_97735_ + 178, this.f_97736_ + 33, 18, 17, List.of(Component.m_237113_((String)("Pressure: " + pressureBar + " bar"))));
        this.drawCustomInfoStat(graphics, mouseX, mouseY, this.f_97735_ + 160, this.f_97736_ + 108, 18, 12, List.of(Component.m_237113_((String)("Steam: " + ZirnoxScreen.format(((ZirnoxMenu)this.f_97732_).getSteam()) + " / " + ZirnoxScreen.format(8000) + " mB"))));
        this.drawCustomInfoStat(graphics, mouseX, mouseY, this.f_97735_ + 142, this.f_97736_ + 108, 18, 12, List.of(Component.m_237113_((String)("CO2: " + ZirnoxScreen.format(((ZirnoxMenu)this.f_97732_).getCarbonDioxide()) + " / " + ZirnoxScreen.format(16000) + " mB"))));
        this.drawCustomInfoStat(graphics, mouseX, mouseY, this.f_97735_ + 178, this.f_97736_ + 108, 18, 12, List.of(Component.m_237113_((String)("Water: " + ZirnoxScreen.format(((ZirnoxMenu)this.f_97732_).getWater()) + " / " + ZirnoxScreen.format(32000) + " mB"))));
    }

    private static String format(int value) {
        return String.format(Locale.ROOT, "%,d", value);
    }

    private static int scale(int value, int max, int steps) {
        if (max <= 0) {
            return 0;
        }
        return Mth.m_14045_((int)(value * steps / max), (int)0, (int)steps);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handled = super.m_6375_(mouseX, mouseY, button);
        if (button == 0) {
            if (mouseX >= (double)(this.f_97735_ + 144) && mouseX < (double)(this.f_97735_ + 158) && mouseY >= (double)(this.f_97736_ + 35) && mouseY < (double)(this.f_97736_ + 49)) {
                this.sendMenuButton(0);
                return true;
            }
            if (mouseX >= (double)(this.f_97735_ + 151) && mouseX < (double)(this.f_97735_ + 187) && mouseY >= (double)(this.f_97736_ + 51) && mouseY < (double)(this.f_97736_ + 87)) {
                this.sendMenuButton(1);
                return true;
            }
        }
        return handled;
    }

    private void sendMenuButton(int id) {
        if (this.f_96541_ != null && this.f_96541_.f_91072_ != null) {
            this.f_96541_.f_91072_.m_105208_(((ZirnoxMenu)this.f_97732_).f_38840_, id);
        }
    }
}

