/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.gui.screen.component;

import com.hbm.HBMLang;
import com.hbm.Inventory.fluid.ExtendedFluidType;
import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.gui.screen.component.BarProgress;
import java.util.Objects;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidType;

public class BarFluid
extends BarProgress {
    public Fluid fluid;
    IntSupplier xgetter = () -> ((BarFluid)this).m_252754_();
    IntSupplier ygetter = () -> ((BarFluid)this).m_252907_();

    public BarFluid(int pX, int pY, int pWidth, int pHeight, Fluid fluid) {
        this(pX, pY, pWidth, pHeight, fluid, (Component)Component.m_237119_());
    }

    public BarFluid(IntSupplier supplierX, IntSupplier supplierY, int pWidth, int pHeight, Fluid fluid) {
        this(supplierX.getAsInt(), supplierY.getAsInt(), pWidth, pHeight, fluid, (Component)Component.m_237119_());
        this.xgetter = supplierX;
        this.ygetter = supplierY;
    }

    public BarFluid(int pX, int pY, int pWidth, int pHeight, Fluid fluid, Component pMessage) {
        super(pX, pY, pWidth, pHeight, 0, 0, 16, 16, BarFluid.getFluidTexture(fluid), pMessage, true);
        this.fluid = fluid;
        if (Objects.equals(pMessage, Component.m_237119_())) {
            MutableComponent fluidName = Component.m_237115_((String)this.fluid.getFluidType().getDescriptionId());
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)HBMLang.TOOLTIP_TANK_VOLUME.key(), (Object[])new Object[]{fluidName, this.progress})));
        }
    }

    @Override
    public void updateData() {
        this.texture = BarFluid.getFluidTexture(this.fluid);
        if (Objects.equals(this.m_6035_(), Component.m_237119_())) {
            MutableComponent fluidName = Component.m_237115_((String)this.fluid.getFluidType().getDescriptionId());
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)HBMLang.TOOLTIP_TANK_VOLUME.key(), (Object[])new Object[]{fluidName, this.progress})));
        }
    }

    @Override
    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.progress == 0.0 || this.fluid.m_6212_(Fluids.f_76191_)) {
            return;
        }
        BarFluid.setColor(this.getFluidColor(this.fluid), pGuiGraphics);
        if (this.isVertical) {
            int barLen = (int)((double)this.f_93619_ * this.progress / (double)this.maxProgress);
            pGuiGraphics.m_280411_(this.texture, this.xgetter.getAsInt(), this.ygetter.getAsInt() + this.f_93619_ - barLen, this.f_93618_, barLen, (float)this.pU, (float)(this.pV + this.f_93619_ - barLen), this.f_93618_, barLen, 256, 256);
        } else {
            int barLen = (int)((double)this.f_93618_ * this.progress / (double)this.maxProgress);
            pGuiGraphics.m_280411_(this.texture, this.xgetter.getAsInt(), this.ygetter.getAsInt(), barLen, this.f_93619_, (float)this.pU, (float)this.pV, barLen, this.f_93619_, 256, 256);
        }
        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static ResourceLocation getFluidTexture(Fluid fluid) {
        FluidType fluidType = fluid.getFluidType();
        if (fluidType instanceof ExtendedFluidType) {
            ExtendedFluidType fluidType2 = (ExtendedFluidType)fluidType;
            return fluidType2.getGUITexture();
        }
        if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
            return ExtendedFluidType.GUI_WATER;
        }
        if (fluid.m_6212_((Fluid)Fluids.f_76195_)) {
            return ExtendedFluidType.GUI_LAVA;
        }
        return ExtendedFluidType.GUI_MILK;
    }

    public int getFluidColor(Fluid fluid) {
        FluidType fluidType = fluid.getFluidType();
        if (fluidType instanceof ExtendedFluidType) {
            ExtendedFluidType fluidType2 = (ExtendedFluidType)fluidType;
            return fluidType2.tintColor;
        }
        if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
            return ModFluids.water.tintColor;
        }
        if (fluid.m_6212_((Fluid)Fluids.f_76195_)) {
            return ModFluids.lava.tintColor;
        }
        return ModFluids.milk.tintColor;
    }
}

