/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.handler.radiation.ChunkRadiationHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;

public class ChunkRadiationHandler3D
extends ChunkRadiationHandler {
    private HashMap<Level, ThreeDimRadiationPerWorld> perWorld = new HashMap();
    private static final String NBT_KEY_CHUNK_RADIATION = "hfr_3d_radiation_";

    @Override
    public float getRadiation(Level level, BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        ThreeDimRadiationPerWorld radWorld = this.perWorld.get(level);
        if (radWorld != null) {
            ChunkPos coords = new ChunkPos(x >> 4, z >> 4);
            int yReg = Mth.m_14045_((int)(y >> 4), (int)0, (int)15);
            Float rad = radWorld.radiation.get(coords)[yReg];
            return rad == null ? 0.0f : rad.floatValue();
        }
        return 0.0f;
    }

    @Override
    public void setRadiation(Level level, BlockPos pos, float rad) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        ThreeDimRadiationPerWorld radWorld = this.perWorld.get(level);
        if (radWorld != null && !level.m_8055_(new BlockPos(x, 0, z)).m_60795_()) {
            ChunkPos coords = new ChunkPos(x >> 4, z >> 4);
            int yReg = Mth.m_14045_((int)(y >> 4), (int)0, (int)15);
            if (radWorld.radiation.containsKey(coords)) {
                radWorld.radiation.get((Object)coords)[yReg] = Float.valueOf(rad);
            }
            level.m_6325_(x, z).m_8092_(true);
        }
    }

    @Override
    public void incrementRad(Level level, BlockPos pos, float rad) {
        this.setRadiation(level, pos, this.getRadiation(level, pos) + rad);
    }

    @Override
    public void decrementRad(Level level, BlockPos pos, float rad) {
        this.setRadiation(level, pos, Math.max(this.getRadiation(level, pos) - rad, 0.0f));
    }

    @Override
    public void updateSystem() {
        for (Map.Entry<Level, ThreeDimRadiationPerWorld> entry : this.perWorld.entrySet()) {
            HashMap<ChunkPos, Float[]> radiation = entry.getValue().radiation;
            HashMap<ChunkPos, Float[]> buff = new HashMap<ChunkPos, Float[]>(radiation);
            radiation.clear();
            for (Map.Entry<ChunkPos, Float[]> chunk : buff.entrySet()) {
                ChunkPos coord = chunk.getKey();
                for (int y = 0; y < 16; ++y) {
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                int type = Math.abs(i) + Math.abs(j) + Math.abs(k);
                                if (type == 3) continue;
                                float percent = type == 0 ? 0.6f : (type == 1 ? 0.075f : 0.025f);
                                ChunkPos newCoord = new ChunkPos(coord.f_45578_ + i, coord.f_45579_ + k);
                                if (!buff.containsKey(newCoord)) continue;
                                int newY = Mth.m_14045_((int)(y + j), (int)0, (int)15);
                                Float[] vals = radiation.get(newCoord);
                                float newRad = vals[newY].floatValue() + chunk.getValue()[newY].floatValue() * percent;
                                vals[newY] = Float.valueOf(Math.max(0.0f, newRad * 0.999f - 0.05f));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void clearSystem(Level level) {
        ThreeDimRadiationPerWorld radWorld = this.perWorld.get(level);
        if (radWorld != null) {
            radWorld.radiation.clear();
        }
    }

    @Override
    public void receiveWorldLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            this.perWorld.put((Level)event.getLevel(), new ThreeDimRadiationPerWorld());
        }
    }

    @Override
    public void receiveWorldUnload(LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            this.perWorld.remove((Level)event.getLevel());
        }
    }

    @Override
    public void receiveChunkLoad(ChunkDataEvent.Load event) {
        ThreeDimRadiationPerWorld radWorld;
        if (!event.getLevel().m_5776_() && (radWorld = this.perWorld.get(event.getLevel())) != null) {
            Float[] vals = new Float[16];
            for (int i = 0; i < 16; ++i) {
                vals[i] = Float.valueOf(event.getData().m_128457_(NBT_KEY_CHUNK_RADIATION + i));
            }
            radWorld.radiation.put(event.getChunk().m_7697_(), vals);
        }
    }

    @Override
    public void receiveChunkSave(ChunkDataEvent.Save event) {
        ThreeDimRadiationPerWorld radWorld;
        if (!event.getLevel().m_5776_() && (radWorld = this.perWorld.get(event.getLevel())) != null) {
            Float[] vals = radWorld.radiation.get(event.getChunk().m_7697_());
            for (int i = 0; i < 16; ++i) {
                float rad = vals[i] == null ? 0.0f : vals[i].floatValue();
                event.getData().m_128350_(NBT_KEY_CHUNK_RADIATION + i, rad);
            }
        }
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        ThreeDimRadiationPerWorld radWorld;
        if (!event.getLevel().m_5776_() && (radWorld = this.perWorld.get(event.getLevel())) != null) {
            radWorld.radiation.remove(event.getChunk());
        }
    }

    public static class ThreeDimRadiationPerWorld {
        public HashMap<ChunkPos, Float[]> radiation = new HashMap();
    }
}

