/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.block.HBMBlockComponent;
import com.hbm.config.RadiationConfig;
import com.hbm.handler.radiation.ChunkRadiationHandler;
import com.hbm.network.ModMessages;
import com.hbm.network.packet.toclient.AuxParticlePacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.Nullable;

public class ChunkRadiationHandlerSimple
extends ChunkRadiationHandler {
    private final HashMap<Level, HashMap<ChunkPos, Float>> perWorld = new HashMap();
    private static final float maxRad = 100000.0f;
    private static final String NBT_KEY_CHUNK_RADIATION = "hfr_simple_radiation";

    @Override
    public float getRadiation(Level level, BlockPos pos) {
        HashMap<ChunkPos, Float> radWorld = this.perWorld.get(level);
        if (radWorld != null) {
            ChunkPos coords = new ChunkPos(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            Float rad = radWorld.get(coords);
            return rad == null ? 0.0f : Mth.m_14036_((float)rad.floatValue(), (float)0.0f, (float)100000.0f);
        }
        return 0.0f;
    }

    @Override
    public void setRadiation(Level level, BlockPos pos, float rad) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        HashMap<ChunkPos, Float> radWorld = this.perWorld.get(level);
        if (radWorld != null && !level.m_8055_(new BlockPos(x, 0, z)).m_60795_()) {
            ChunkPos coords = new ChunkPos(x >> 4, z >> 4);
            radWorld.put(coords, Float.valueOf(Mth.m_14036_((float)rad, (float)0.0f, (float)100000.0f)));
            level.m_6325_(x, z).m_8092_(true);
        }
    }

    @Override
    public void incrementRad(Level level, BlockPos pos, float rad) {
        this.setRadiation(level, pos, this.getRadiation(level, pos) + rad);
    }

    @Override
    public void decrementRad(Level level, BlockPos pos, float rad) {
        this.setRadiation(level, pos, Math.max(this.getRadiation(level, pos) - rad, 0.0f));
    }

    @Override
    public void updateSystem() {
        for (Map.Entry<Level, HashMap<ChunkPos, Float>> entry : this.perWorld.entrySet()) {
            HashMap<ChunkPos, Float> radiation = entry.getValue();
            HashMap<ChunkPos, Float> buff = new HashMap<ChunkPos, Float>(radiation);
            radiation.clear();
            Level level = entry.getKey();
            for (Map.Entry<ChunkPos, Float> chunk : buff.entrySet()) {
                if (chunk.getValue().floatValue() == 0.0f) continue;
                ChunkPos coord = chunk.getKey();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        int type = Math.abs(i) + Math.abs(j);
                        float percent = type == 0 ? 0.6f : (type == 1 ? 0.075f : 0.025f);
                        ChunkPos newCoord = new ChunkPos(coord.f_45578_ + i, coord.f_45579_ + j);
                        if (buff.containsKey(newCoord)) {
                            Float val = radiation.get(newCoord);
                            float rad = val == null ? 0.0f : val.floatValue();
                            float newRad = rad + chunk.getValue().floatValue() * percent;
                            newRad = Mth.m_14036_((float)0.0f, (float)(newRad * 0.99f - 0.05f), (float)100000.0f);
                            radiation.put(newCoord, Float.valueOf(newRad));
                        } else {
                            radiation.put(newCoord, Float.valueOf(chunk.getValue().floatValue() * percent));
                        }
                        float rad = radiation.get(newCoord).floatValue();
                        if (!(rad > (float)RadiationConfig.fogRad) || level == null || level.f_46441_.m_188503_(RadiationConfig.fogCh) != 0 || !level.m_7232_(coord.f_45578_, coord.f_45579_)) continue;
                        int x = coord.f_45578_ * 16 + level.f_46441_.m_188503_(16);
                        int z = coord.f_45579_ * 16 + level.f_46441_.m_188503_(16);
                        int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z) + level.f_46441_.m_188503_(5);
                        if (!(level instanceof ServerLevel)) continue;
                        ServerLevel serverLevel = (ServerLevel)level;
                        Packet packet = ModMessages.netHandler.toVanillaPacket((Object)new AuxParticlePacket(x, y, z, 3), NetworkDirection.PLAY_TO_CLIENT);
                        serverLevel.m_7654_().m_6846_().m_11241_(null, (double)x, (double)y, (double)z, 100.0, serverLevel.m_46472_(), packet);
                    }
                }
            }
        }
    }

    @Override
    public void clearSystem(Level level) {
        HashMap<ChunkPos, Float> radWorld = this.perWorld.get(level);
        if (radWorld != null) {
            radWorld.clear();
        }
    }

    @Override
    public void receiveWorldLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            this.perWorld.put((Level)event.getLevel(), new HashMap());
        }
    }

    @Override
    public void receiveWorldUnload(LevelEvent.Unload event) {
        if (!event.getLevel().m_5776_()) {
            this.perWorld.remove((Level)event.getLevel());
        }
    }

    @Override
    public void receiveChunkLoad(ChunkDataEvent.Load event) {
        ChunkAccess chunk = event.getChunk();
        if (chunk instanceof ProtoChunk) {
            ProtoChunk protoChunk = (ProtoChunk)chunk;
            Level level = (Level)chunk.f_187611_;
            this.receiveChunkLoad(level, event);
        } else if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            this.receiveChunkLoad(levelChunk.m_62953_(), event);
        }
    }

    public void receiveChunkLoad(Level level, ChunkDataEvent.Load event) {
        HashMap<ChunkPos, Float> radWorld;
        if (!level.m_5776_() && (radWorld = this.perWorld.get(level)) != null) {
            radWorld.put(event.getChunk().m_7697_(), Float.valueOf(event.getData().m_128457_(NBT_KEY_CHUNK_RADIATION)));
        }
    }

    @Override
    public void receiveChunkSave(ChunkDataEvent.Save event) {
        ChunkAccess chunk = event.getChunk();
        if (chunk instanceof ProtoChunk) {
            ProtoChunk protoChunk = (ProtoChunk)chunk;
            Level level = (Level)chunk.f_187611_;
            this.receiveChunkSave(level, event);
        } else if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            this.receiveChunkSave(levelChunk.m_62953_(), event);
        }
    }

    public void receiveChunkSave(Level level, ChunkDataEvent.Save event) {
        HashMap<ChunkPos, Float> radWorld;
        if (!level.m_5776_() && (radWorld = this.perWorld.get(level)) != null) {
            Float val = radWorld.get(event.getChunk().m_7697_());
            float rad = val == null ? 0.0f : val.floatValue();
            event.getData().m_128350_(NBT_KEY_CHUNK_RADIATION, rad);
        }
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        ChunkAccess chunk = event.getChunk();
        if (chunk instanceof ProtoChunk) {
            ProtoChunk protoChunk = (ProtoChunk)chunk;
            Level level = (Level)chunk.f_187611_;
            this.receiveChunkUnload(level, event);
        } else if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            this.receiveChunkUnload(levelChunk.m_62953_(), event);
        }
    }

    public void receiveChunkUnload(@Nullable Level level, ChunkEvent.Unload event) {
        HashMap<ChunkPos, Float> radWorld;
        if (level != null && !level.m_5776_() && (radWorld = this.perWorld.get(level)) != null) {
            radWorld.remove(event.getChunk().m_7697_());
        }
    }

    @Override
    public void handleWorldDestruction() {
        int count = 10;
        int threshold = 10;
        int chunks = 5;
        for (Map.Entry<Level, HashMap<ChunkPos, Float>> per : this.perWorld.entrySet()) {
            Level level = per.getKey();
            HashMap<ChunkPos, Float> list = per.getValue();
            Object[] entries = list.entrySet().toArray();
            if (entries.length == 0) continue;
            for (int c = 0; c < chunks; ++c) {
                Map.Entry randEnt = (Map.Entry)entries[level.f_46441_.m_188503_(entries.length)];
                ChunkPos coords = (ChunkPos)randEnt.getKey();
                ServerLevel serv = (ServerLevel)level;
                ServerChunkCache provider = serv.m_7726_();
                for (int i = 0; i < count; ++i) {
                    if (randEnt == null || ((Float)randEnt.getValue()).floatValue() < (float)threshold || !provider.m_5563_(coords.f_45578_, coords.f_45579_)) continue;
                    for (int a = 0; a < 16; ++a) {
                        for (int b = 0; b < 16; ++b) {
                            int z;
                            int y;
                            int x;
                            BlockState blockState;
                            if (level.f_46441_.m_188503_(3) != 0 || (blockState = level.m_8055_(new BlockPos(x = coords.m_151390_() - 8 + a, y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = coords.m_151393_() - 8 + b) - level.f_46441_.m_188503_(2), z))).m_60795_()) continue;
                            if (blockState.m_60713_(Blocks.f_50440_)) {
                                level.m_7731_(new BlockPos(x, y, z), ((Block)HBMBlockComponent.WAST_EARTH.get()).m_49966_(), 3);
                                continue;
                            }
                            if (blockState.m_60713_(Blocks.f_50359_)) {
                                level.m_7731_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_(), 11);
                                continue;
                            }
                            if (!blockState.m_204336_(BlockTags.f_13035_) || blockState.m_60713_((Block)HBMBlockComponent.WAST_LEAVES.get())) continue;
                            if (level.f_46441_.m_188503_(7) <= 5) {
                                level.m_7731_(new BlockPos(x, y, z), ((Block)HBMBlockComponent.WAST_LEAVES.get()).m_49966_(), 3);
                                continue;
                            }
                            level.m_7731_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_(), 11);
                        }
                    }
                }
            }
        }
    }

    public static class SimpleRadiationPerWorld {
        public HashMap<ChunkPos, Float> radiation = new HashMap();
    }
}

