/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.init;

import com.hbm.render.entity.AtomicBombEntity;
import com.hbm.render.entity.AtomicBombExplosionEntity;
import com.hbm.render.entity.FiveBombEntity;
import com.hbm.render.entity.FiveHundredKgExplosionEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class BigExplosivesModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"big_explosives");
    public static final RegistryObject<EntityType<FiveBombEntity>> FIVE_BOMB = BigExplosivesModEntities.register("five_bomb", EntityType.Builder.m_20704_(FiveBombEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FiveBombEntity::new).m_20699_(1.0f, 1.5f));
    public static final RegistryObject<EntityType<FiveHundredKgExplosionEntity>> FIVE_HUNDRED_KG_EXPLOSION = BigExplosivesModEntities.register("five_hundred_kg_explosion", EntityType.Builder.m_20704_(FiveHundredKgExplosionEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FiveHundredKgExplosionEntity::new).m_20699_(5.0f, 5.0f));
    public static final RegistryObject<EntityType<AtomicBombEntity>> ATOMIC_BOMB = BigExplosivesModEntities.register("atomic_bomb", EntityType.Builder.m_20704_(AtomicBombEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(AtomicBombEntity::new).m_20699_(1.0f, 1.5f));
    public static final RegistryObject<EntityType<AtomicBombExplosionEntity>> ATOMIC_BOMB_EXPLOSION = BigExplosivesModEntities.register("atomic_bomb_explosion", EntityType.Builder.m_20704_(AtomicBombExplosionEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(AtomicBombExplosionEntity::new).m_20699_(60.0f, 60.0f));

    private BigExplosivesModEntities() {
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String name, EntityType.Builder<T> builder) {
        return REGISTRY.register(name, () -> builder.m_20712_(name));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FiveBombEntity.init();
            FiveHundredKgExplosionEntity.init();
            AtomicBombEntity.init();
            AtomicBombExplosionEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)FIVE_BOMB.get(), FiveBombEntity.createAttributes().m_22265_());
        event.put((EntityType)FIVE_HUNDRED_KG_EXPLOSION.get(), FiveHundredKgExplosionEntity.createAttributes().m_22265_());
        event.put((EntityType)ATOMIC_BOMB.get(), AtomicBombEntity.createAttributes().m_22265_());
        event.put((EntityType)ATOMIC_BOMB_EXPLOSION.get(), AtomicBombExplosionEntity.createAttributes().m_22265_());
    }
}

