/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.armor;

import com.hbm.item.armor.ItemArmorMod;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorModHandler {
    public static final int helmet_only = 0;
    public static final int plate_only = 1;
    public static final int legs_only = 2;
    public static final int boots_only = 3;
    public static final int servos = 4;
    public static final int cladding = 5;
    public static final int kevlar = 6;
    public static final int extra = 7;
    public static final int battery = 8;
    public static final int MOD_SLOTS = 9;
    public static final UUID[] UUIDs = new UUID[]{UUID.fromString("8d6e5c77-133e-4056-9c80-a9e42a1a0b65"), UUID.fromString("b1b7ee0e-1d14-4400-8037-f7f2e02f21ca"), UUID.fromString("30b50d2a-4858-4e5b-88d4-3e3612224238"), UUID.fromString("426ee0d0-7587-4697-aaef-4772ab202e78")};
    public static final UUID[] fixedUUIDs = new UUID[]{UUID.fromString("e572caf4-3e65-4152-bc79-c4d4048cbd29"), UUID.fromString("bed30902-8a6a-4769-9f65-2a9b67469fff"), UUID.fromString("baebf7b3-1eda-4a14-b233-068e2493e9a2"), UUID.fromString("28016c1b-d992-4324-9409-a9f9f0ffb85c")};
    public static final String MOD_COMPOUND_KEY = "ntm_armor_mods";
    public static final String MOD_SLOT_KEY = "mod_slot_";

    public static boolean isApplicable(ItemStack armor, ItemStack mod) {
        ArmorItem armorItem;
        Item item;
        block3: {
            block2: {
                if (armor == null || mod == null || !((item = armor.m_41720_()) instanceof ArmorItem)) break block2;
                armorItem = (ArmorItem)item;
                item = mod.m_41720_();
                if (item instanceof ItemArmorMod) break block3;
            }
            return false;
        }
        ItemArmorMod aMod = (ItemArmorMod)item;
        ArmorItem.Type type = armorItem.m_266204_();
        return type == ArmorItem.Type.HELMET && aMod.helmet || type == ArmorItem.Type.CHESTPLATE && aMod.chestplate || type == ArmorItem.Type.LEGGINGS && aMod.leggings || type == ArmorItem.Type.BOOTS && aMod.boots;
    }

    public static void applyMod(ItemStack armor, ItemStack mod) {
        CompoundTag tag = armor.m_41698_(MOD_COMPOUND_KEY);
        ItemArmorMod aMod = (ItemArmorMod)mod.m_41720_();
        Item item = mod.m_41720_();
        if (item instanceof ItemArmorMod) {
            ItemArmorMod armorMod = (ItemArmorMod)item;
            int slot = armorMod.type.ordinal();
            tag.m_128365_(MOD_SLOT_KEY + slot, (Tag)mod.serializeNBT());
        }
    }

    public static void removeMod(ItemStack armor, int slot) {
        CompoundTag tag = armor.m_41698_(MOD_COMPOUND_KEY);
        tag.m_128473_(MOD_SLOT_KEY + slot);
        if (tag.m_128456_()) {
            armor.m_41784_().m_128473_(MOD_COMPOUND_KEY);
        }
    }

    public static void clearMods(ItemStack armor) {
        if (armor.m_41782_() && armor.m_41783_() != null) {
            armor.m_41783_().m_128473_(MOD_COMPOUND_KEY);
        }
    }

    public static boolean hasMods(ItemStack armor) {
        return armor.m_41737_(MOD_COMPOUND_KEY) == null;
    }

    public static ItemStack[] pryMods(ItemStack armor) {
        ItemStack[] slots = new ItemStack[9];
        CompoundTag mods = armor.m_41737_(MOD_COMPOUND_KEY);
        if (mods == null) {
            return slots;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            slots[i] = stack = ItemStack.m_41712_((CompoundTag)mods.m_128469_(MOD_SLOT_KEY + i));
        }
        return slots;
    }

    public static ItemStack pryMod(ItemStack armor, int slot) {
        CompoundTag tag = armor.m_41737_(MOD_COMPOUND_KEY);
        if (tag == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_(MOD_SLOT_KEY + slot)));
        if (!stack.m_41619_()) {
            return stack;
        }
        ArmorModHandler.removeMod(armor, slot);
        return ItemStack.f_41583_;
    }
}

