/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.armor;

import com.hbm.api.item.IGasMask;
import com.hbm.item.armor.ArmorModHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorRegistry {
    public static HashMap<Item, ArrayList<HazardClass>> hazardClasses = new HashMap();

    public static void registerHazard(Item item, HazardClass ... hazards) {
        hazardClasses.put(item, new ArrayList<HazardClass>(Arrays.asList(hazards)));
    }

    public static ItemStack getArmor(LivingEntity entity, int slot) {
        Iterable armorSlots = entity.m_6168_();
        if (armorSlots instanceof List) {
            List armorList = (List)armorSlots;
            return (ItemStack)armorList.get(slot);
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack next = (ItemStack)entity.m_6168_().iterator().next();
            if (i != slot) continue;
            return next;
        }
        return ItemStack.f_41583_;
    }

    public static boolean checkArmorNull(LivingEntity entity, int slot) {
        return ArmorRegistry.getArmor(entity, slot).m_41619_();
    }

    public static boolean hasAllProtection(LivingEntity entity, int slot, HazardClass ... clazz) {
        if (ArmorRegistry.checkArmorNull(entity, slot)) {
            return false;
        }
        Set<HazardClass> list = ArmorRegistry.getProtectionFromItem(ArmorRegistry.getArmor(entity, slot), entity);
        return list.containsAll(Arrays.asList(clazz));
    }

    public static boolean hasAnyProtection(LivingEntity entity, int slot, HazardClass ... clazz) {
        if (ArmorRegistry.checkArmorNull(entity, slot)) {
            return false;
        }
        Set<HazardClass> list = ArmorRegistry.getProtectionFromItem(ArmorRegistry.getArmor(entity, slot), entity);
        for (HazardClass haz : clazz) {
            if (!list.contains((Object)haz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProtection(LivingEntity entity, int slot, HazardClass clazz) {
        if (ArmorRegistry.checkArmorNull(entity, slot)) {
            return false;
        }
        Set<HazardClass> list = ArmorRegistry.getProtectionFromItem(ArmorRegistry.getArmor(entity, slot), entity);
        return list.contains((Object)clazz);
    }

    public static Set<HazardClass> getProtectionFromItem(ItemStack stack, LivingEntity entity) {
        IGasMask mask;
        ItemStack filter;
        HashSet<HazardClass> prot = new HashSet<HazardClass>();
        Item item = stack.m_41720_();
        if (hazardClasses.containsKey(item)) {
            prot.addAll((Collection)hazardClasses.get(item));
        }
        if (item instanceof IGasMask && (filter = (mask = (IGasMask)item).getFilter(stack, entity)) != null) {
            List filProt = (List)hazardClasses.get(filter.m_41720_()).clone();
            for (HazardClass c : mask.getBlacklist(stack, entity)) {
                filProt.remove((Object)c);
            }
            prot.addAll(filProt);
        }
        if (ArmorModHandler.hasMods(stack)) {
            ItemStack[] mods;
            for (ItemStack mod : mods = ArmorModHandler.pryMods(stack)) {
                if (mod == null) continue;
                prot.addAll(ArmorRegistry.getProtectionFromItem(mod, entity));
            }
        }
        return prot;
    }

    public static enum HazardClass {
        GAS_LUNG("hazard.gasChlorine"),
        GAS_MONOXIDE("hazard.gasMonoxide"),
        GAS_INERT("hazard.gasInert"),
        PARTICLE_COARSE("hazard.particleCoarse"),
        PARTICLE_FINE("hazard.particleFine"),
        BACTERIA("hazard.bacteria"),
        GAS_BLISTERING("hazard.corrosive"),
        SAND("hazard.sand"),
        LIGHT("hazard.light");

        public final String lang;

        private HazardClass(String lang) {
            this.lang = lang;
        }
    }
}

