/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.armor;

import com.hbm.HBM;
import com.hbm.HBMLang;
import com.hbm.block.HBMMachine;
import com.hbm.blockentity.tools.TileEntityGeiger;
import com.hbm.item.HBMCombat;
import com.hbm.item.HBMtools;
import com.hbm.item.armor.IArmorDisableModel;
import com.hbm.render.model.armor.ModelArmorBase;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.Nullable;

public class ItemArmorFSB
extends ArmorItem
implements IArmorDisableModel {
    private String texture = "";
    private ResourceLocation overlay = null;
    public List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    public boolean noHelmet = false;
    public boolean vats = false;
    public boolean thermal = false;
    public boolean geigerSound = false;
    public boolean customGeiger = false;
    public boolean hardLanding = false;
    public int dashCount = 0;
    public int stepSize = 0;
    public SoundEvent step;
    public SoundEvent jump;
    public SoundEvent fall;
    public Supplier<HBMCombat.Suit> suit;
    private HashSet<IArmorDisableModel.EnumPlayerPart> hidden = new HashSet();
    private boolean needsFullSet = false;

    public ItemArmorFSB(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties, Supplier<HBMCombat.Suit> suit) {
        super(pMaterial, pType, pProperties);
        this.suit = suit;
    }

    public ItemArmorFSB(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        this(pMaterial, pType, pProperties, () -> new HBMCombat.Suit(null, null, null, null));
    }

    public ItemArmorFSB addEffect(MobEffectInstance ... effect) {
        this.effects.addAll(List.of(effect));
        return this;
    }

    public ItemArmorFSB enableVATS(boolean vats) {
        this.vats = vats;
        return this;
    }

    public ItemArmorFSB enableThermalSight(boolean thermal) {
        this.thermal = thermal;
        return this;
    }

    public ItemArmorFSB setHasGeigerSound(boolean geiger) {
        this.geigerSound = geiger;
        return this;
    }

    public ItemArmorFSB setHasCustomGeiger(boolean geiger) {
        this.customGeiger = geiger;
        return this;
    }

    public ItemArmorFSB setHasHardLanding(boolean hardLanding) {
        this.hardLanding = hardLanding;
        return this;
    }

    public ItemArmorFSB setDashCount(int dashCount) {
        this.dashCount = dashCount;
        return this;
    }

    public ItemArmorFSB setStepSize(int stepSize) {
        this.stepSize = stepSize;
        return this;
    }

    public ItemArmorFSB setStep(SoundEvent step) {
        this.step = step;
        return this;
    }

    public ItemArmorFSB setJump(SoundEvent jump) {
        this.jump = jump;
        return this;
    }

    public ItemArmorFSB setFall(SoundEvent fall) {
        this.fall = fall;
        return this;
    }

    public ItemArmorFSB setOverlay(String path) {
        this.overlay = new ResourceLocation(path);
        return this;
    }

    public ItemArmorFSB suit(Supplier<HBMCombat.Suit> suit) {
        this.suit = suit;
        return this;
    }

    public ItemArmorFSB cloneStats(ItemArmorFSB original) {
        this.effects = original.effects;
        this.noHelmet = original.noHelmet;
        this.vats = original.vats;
        this.thermal = original.thermal;
        this.geigerSound = original.geigerSound;
        this.customGeiger = original.customGeiger;
        this.hardLanding = original.hardLanding;
        this.dashCount = original.dashCount;
        this.stepSize = original.stepSize;
        this.step = original.step;
        this.jump = original.jump;
        this.fall = original.fall;
        return this;
    }

    public String getTexture() {
        return this.texture;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, list, pIsAdvanced);
        ArrayList<MutableComponent> toAdd = new ArrayList<MutableComponent>();
        if (!this.effects.isEmpty()) {
            MutableComponent tipeffect = Component.m_237119_();
            for (int i = 0; i < this.effects.size(); ++i) {
                tipeffect.m_7220_(this.effects.get(i).m_19544_().m_19482_());
                if (i >= this.effects.size() - 1) continue;
                tipeffect.m_130946_(", ");
            }
            toAdd.add(tipeffect.m_130940_(ChatFormatting.AQUA));
        }
        if (this.geigerSound) {
            toAdd.add(Component.m_237115_((String)HBMLang.ARMOR_GEIGERSOUND.key()).m_130940_(ChatFormatting.GOLD));
        }
        if (this.customGeiger) {
            toAdd.add(Component.m_237115_((String)HBMLang.ARMOR_GEIGERHUD.key()).m_130940_(ChatFormatting.GOLD));
        }
        if (this.vats) {
            toAdd.add(Component.m_237115_((String)HBMLang.ARMOR_VATS.key()).m_130940_(ChatFormatting.RED));
        }
        if (this.thermal) {
            toAdd.add(Component.m_237115_((String)HBMLang.ARMOR_THERMAL.key()).m_130940_(ChatFormatting.RED));
        }
        if (this.hardLanding) {
            toAdd.add(Component.m_237115_((String)HBMLang.ARMOR_HARDLANDING.key()).m_130940_(ChatFormatting.RED));
        }
        if (this.stepSize != 0) {
            toAdd.add(Component.m_237115_((String)HBMLang.ARMOR_STEPSIZE.key()).m_130940_(ChatFormatting.BLUE));
        }
        if (this.dashCount > 0) {
            toAdd.add(Component.m_237115_((String)HBMLang.ARMOR_DASH.key()).m_130940_(ChatFormatting.AQUA));
        }
        if (!toAdd.isEmpty()) {
            list.add((Component)Component.m_237115_((String)HBMLang.ARMOR_FSB.key()).m_130940_(ChatFormatting.GOLD));
            list.addAll(toAdd);
        }
    }

    public static boolean hasFSBArmor(Player player) {
        ItemStack plateSlot = (ItemStack)player.m_150109_().f_35975_.get(2);
        Item item = plateSlot.m_41720_();
        if (item instanceof ItemArmorFSB) {
            ItemArmorFSB armorFSB = (ItemArmorFSB)item;
            HBMCombat.Suit suit = armorFSB.suit.get();
            if (suit.HELMET() != null && !player.m_150109_().m_36052_(3).m_150930_((Item)suit.HELMET().get())) {
                return false;
            }
            if (suit.LEGS() != null && !player.m_150109_().m_36052_(1).m_150930_((Item)suit.LEGS().get())) {
                return false;
            }
            return suit.BOOT() == null || player.m_150109_().m_36052_(0).m_150930_((Item)suit.BOOT().get());
        }
        return false;
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        boolean step = true;
        if (ItemArmorFSB.hasFSBArmor(player)) {
            ItemArmorFSB chestplate = (ItemArmorFSB)player.m_150109_().m_36052_(2).m_41720_();
            if (!level.m_5776_()) {
                for (MobEffectInstance effect : chestplate.effects) {
                    player.m_7292_(effect);
                }
                if (chestplate.geigerSound && !player.m_150109_().m_18949_(Set.of((Item)HBMtools.GEIGER_COUNTER.get(), ((Block)HBMMachine.GEIGER_COUNTER.get()).m_5456_()))) {
                    TileEntityGeiger.show(level, null, player, player.f_19797_, TileEntityGeiger.check(level, player.m_20097_()));
                }
            } else if (step && chestplate.step != null && player.m_20096_()) {
                ItemArmorFSB.steppy(player, chestplate.step);
            }
        }
    }

    public static void steppy(Player player, SoundEvent sound) {
    }

    public boolean isArmorEnabled(ItemStack stack) {
        return true;
    }

    public ItemArmorFSB hides(IArmorDisableModel.EnumPlayerPart ... parts) {
        Collections.addAll(this.hidden, parts);
        return this;
    }

    public ItemArmorFSB setFullSetForHide() {
        this.needsFullSet = true;
        return this;
    }

    @Override
    public boolean disablesPart(Player player, ItemStack stack, IArmorDisableModel.EnumPlayerPart part) {
        return false;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return super.getArmorTexture(stack, entity, slot, type);
    }

    public void handleJump(Player player) {
    }

    public void handleFall(Player player) {
    }

    public void handleAttack(LivingAttackEvent event) {
    }

    public void handleHurt(LivingHurtEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderObjItem(ItemDisplayContext pDisplayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderStandard(ItemArmorFSB armorFSB, ModelArmorBase model, String helmet, String chest, String arm, String leg, ItemDisplayContext pDisplayContext, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        float scale = 0.08f;
        float xRot = -45.0f;
        float yRot = 225.0f;
        float xOffset = 0.5f;
        float yOffset = 0.35f;
        float zOffSet = 0.5f;
        if (pDisplayContext != ItemDisplayContext.GUI) {
            xRot = 0.0f;
            scale = 0.04f;
            yOffset = 0.5f;
            if (pDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                yRot = 135.0f;
            } else if (pDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                yRot = 45.0f;
            } else if (pDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                yRot = -45.0f;
            }
        }
        ResourceLocation texture = HBM.rl("textures/models/armor/");
        if (armorFSB.m_266204_() == ArmorItem.Type.HELMET) {
            pPoseStack.m_85837_((double)xOffset, (double)yOffset + 0.35, (double)zOffSet);
            pPoseStack.m_252781_(Axis.f_252495_.m_252977_(xRot));
            pPoseStack.m_252781_(Axis.f_252392_.m_252977_(yRot));
            pPoseStack.m_85841_(scale * 0.8f, scale * 0.8f, scale * 0.8f);
            VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture.m_266382_(helmet + ".png")));
            model.chead.renderStatic(pPoseStack, buffer, pPackedLight, pPackedOverlay);
        } else if (armorFSB.m_266204_() == ArmorItem.Type.CHESTPLATE) {
            pPoseStack.m_252880_(xOffset, yOffset, zOffSet);
            pPoseStack.m_252781_(Axis.f_252495_.m_252977_(xRot));
            pPoseStack.m_252781_(Axis.f_252392_.m_252977_(yRot));
            pPoseStack.m_85841_(scale * 0.6f, scale * 0.6f, scale * 0.6f);
            VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture.m_266382_(chest + ".png")));
            model.cbody.renderStatic(pPoseStack, buffer, pPackedLight, pPackedOverlay);
            VertexConsumer buffer1 = pBuffer.m_6299_(RenderType.m_110470_((ResourceLocation)texture.m_266382_(arm + ".png")));
            model.cleftArm.renderStatic(pPoseStack, buffer1, pPackedLight, pPackedOverlay);
            model.crightArm.renderStatic(pPoseStack, buffer1, pPackedLight, pPackedOverlay);
        } else if (armorFSB.m_266204_() == ArmorItem.Type.LEGGINGS) {
            if (pDisplayContext != ItemDisplayContext.GUI) {
                yOffset += 0.2f;
            }
            pPoseStack.m_85837_((double)xOffset, (double)yOffset - 0.65, (double)zOffSet);
            pPoseStack.m_252781_(Axis.f_252495_.m_252977_(xRot));
            pPoseStack.m_252781_(Axis.f_252392_.m_252977_(yRot));
            pPoseStack.m_85841_(scale, scale, scale);
            VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture.m_266382_(leg + ".png")));
            model.cleftLeg.renderStatic(pPoseStack, buffer, pPackedLight, pPackedOverlay);
            model.crightLeg.renderStatic(pPoseStack, buffer, pPackedLight, pPackedOverlay);
        } else if (armorFSB.m_266204_() == ArmorItem.Type.BOOTS) {
            if (pDisplayContext != ItemDisplayContext.GUI) {
                yOffset += 0.2f;
            }
            pPoseStack.m_252880_(xOffset, yOffset - 1.0f, zOffSet);
            pPoseStack.m_252781_(Axis.f_252495_.m_252977_(xRot));
            pPoseStack.m_252781_(Axis.f_252392_.m_252977_(yRot));
            pPoseStack.m_85841_(scale, scale, scale);
            VertexConsumer buffer = pBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture.m_266382_(leg + ".png")));
            model.cleftFoot.renderStatic(pPoseStack, buffer, pPackedLight, pPackedOverlay);
            model.crightFoot.renderStatic(pPoseStack, buffer, pPackedLight, pPackedOverlay);
        }
    }

    public static enum FSBTex {
        helmet,
        chest,
        arm,
        leg;

    }
}

