/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.armor;

import com.hbm.api.fluid.FluidUtils;
import com.hbm.api.fluid.ItemStackFluidHandler;
import com.hbm.capabilities.ItemCapabilityWrapper;
import com.hbm.item.HBMCombat;
import com.hbm.item.armor.ItemArmorFSB;
import com.hbm.item.tool.BatteryItem;
import com.hbm.utils.BobMth;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ItemArmorFSBFueled
extends ItemArmorFSB {
    Fluid fluid;
    public int maxFuel = 1;
    public int fillRate;
    public int consumption;
    public int drain;

    public ItemArmorFSBFueled(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties, Fluid fuel, int maxFuel, int fillRate, int consumption, int drain) {
        this(pMaterial, pType, pProperties.m_41503_(BatteryItem.DEFAULT_DAMAGE), fuel, maxFuel, fillRate, consumption, drain, null);
    }

    public ItemArmorFSBFueled(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties, Fluid fuel, int maxFuel, int fillRate, int consumption, int drain, Supplier<HBMCombat.Suit> suit) {
        super(pMaterial, pType, pProperties.m_41503_(BatteryItem.DEFAULT_DAMAGE), suit);
        this.fluid = fuel;
        this.maxFuel = maxFuel;
        this.fillRate = fillRate;
        this.consumption = consumption;
        this.drain = drain;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        ArrayList<ItemStackFluidHandler> capabilities = new ArrayList<ItemStackFluidHandler>();
        capabilities.add(new ItemStackFluidHandler(this.maxFuel, this.fillRate, 0, this.fluid));
        return new ItemCapabilityWrapper(stack, (ItemCapabilityWrapper.ItemCapability[])capabilities.toArray(ItemCapabilityWrapper.ItemCapability[]::new));
    }

    @Override
    public boolean isArmorEnabled(ItemStack stack) {
        return FluidUtils.getAmount((ICapabilityProvider)stack) > 0;
    }

    @Override
    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        if (!player.m_7500_() && level.m_46467_() % 10L == 0L && this.drain > 0 && ItemArmorFSBFueled.hasFSBArmor(player)) {
            FluidUtils.absorbOnly((ICapabilityProvider)stack, this.drain);
        }
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        FluidStack fluid1 = FluidUtils.getFluid((ICapabilityProvider)pStack);
        list.add((Component)((MutableComponent)fluid1.getDisplayName()).m_130946_(": " + BobMth.getShortNumber(fluid1.getAmount()) + " / " + BobMth.getShortNumber(this.maxFuel)));
        super.m_7373_(pStack, pLevel, list, pIsAdvanced);
    }

    public boolean m_142522_(ItemStack pStack) {
        return FluidUtils.getAmount((ICapabilityProvider)pStack) < this.maxFuel;
    }
}

