/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.armor;

import com.hbm.HBMLang;
import com.hbm.api.energy.IEnergyHandler;
import com.hbm.api.energy.ItemStackEnergyHandler;
import com.hbm.api.energy.TransmitUtils;
import com.hbm.capabilities.HBMCaps;
import com.hbm.capabilities.ItemCapabilityWrapper;
import com.hbm.item.armor.ItemArmorFSB;
import com.hbm.item.tool.BatteryItem;
import com.hbm.utils.BobMth;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class ItemArmorFSBPowered
extends ItemArmorFSB {
    public long capacity = 1L;
    public long input;
    public long consumption;
    public long tickDrain;

    public ItemArmorFSBPowered(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties, long capacity, long in, long consum, long drain) {
        super(pMaterial, pType, pProperties.m_41503_(BatteryItem.DEFAULT_DAMAGE));
        this.capacity = capacity;
        this.input = in;
        this.consumption = consum;
        this.tickDrain = drain;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        ArrayList<ItemStackEnergyHandler> capabilities = new ArrayList<ItemStackEnergyHandler>();
        capabilities.add(new ItemStackEnergyHandler(this.capacity, this.input, 0L, true));
        return new ItemCapabilityWrapper(stack, (ItemCapabilityWrapper.ItemCapability[])capabilities.toArray(ItemCapabilityWrapper.ItemCapability[]::new));
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        list.add((Component)Component.m_237110_((String)HBMLang.TOOLTIP_CHARGERATE.key(), (Object[])new Object[]{BobMth.getShortNumber(ItemArmorFSBPowered.getCharge(pStack)), BobMth.getShortNumber(ItemArmorFSBPowered.getCapacity(pStack))}));
        super.m_7373_(pStack, pLevel, list, pIsAdvanced);
    }

    public static long getCharge(ItemStack stack) {
        long result = 0L;
        IEnergyHandler energyHandler = (IEnergyHandler)stack.getCapability(HBMCaps.LONG_ENERGY).orElse(null);
        if (energyHandler != null) {
            result = energyHandler.getStored();
        }
        return result;
    }

    public static long getCapacity(ItemStack stack) {
        long result = 0L;
        IEnergyHandler energyHandler = (IEnergyHandler)stack.getCapability(HBMCaps.LONG_ENERGY).orElse(null);
        if (energyHandler != null) {
            result = energyHandler.getCapacity();
        }
        return result;
    }

    @Override
    public boolean isArmorEnabled(ItemStack stack) {
        return ItemArmorFSBPowered.getCharge(stack) > 0L;
    }

    public boolean m_142522_(ItemStack pStack) {
        return ItemArmorFSBPowered.getCharge(pStack) < ItemArmorFSBPowered.getCapacity(pStack);
    }

    @Override
    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        if (this.tickDrain > 0L && !level.m_5776_() && !player.m_7500_() && ItemArmorFSBPowered.hasFSBArmor(player)) {
            TransmitUtils.dischargeOnly((ICapabilityProvider)stack, this.tickDrain);
        }
    }
}

