/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.blockitem;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class IronCrateItem
extends BlockItem {
    private final int slotCount;

    public IronCrateItem(Block block, Item.Properties properties) {
        this(block, properties, 36);
    }

    protected IronCrateItem(Block block, Item.Properties properties, int slotCount) {
        super(block, properties);
        this.slotCount = slotCount;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag beTag = stack.m_41737_("BlockEntityTag");
        if (beTag == null || !beTag.m_128441_("Items")) {
            if (flag.m_7050_()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm.crate_empty").m_130940_(ChatFormatting.GREEN));
            }
            return;
        }
        ItemStackHandler handler = new ItemStackHandler(this.slotCount);
        handler.deserializeNBT(beTag);
        int shown = 0;
        int filled = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack content = handler.getStackInSlot(slot);
            if (content.m_41619_()) continue;
            ++filled;
            if (shown >= 10) continue;
            tooltip.add((Component)Component.m_237113_((String)("  " + content.m_41786_().getString() + " \u00d7" + content.m_41613_())).m_130940_(ChatFormatting.AQUA));
            ++shown;
        }
        if (filled == 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm.crate_empty").m_130940_(ChatFormatting.GREEN));
        } else if (filled > shown) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm.crate_more", (Object[])new Object[]{filled - shown}).m_130940_(this.fillColor(filled)));
        } else if (flag.m_7050_()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm.crate_fill", (Object[])new Object[]{filled, this.slotCount}).m_130940_(this.fillColor(filled)));
        }
    }

    private ChatFormatting fillColor(int filledSlots) {
        float percent;
        float f = percent = this.slotCount <= 0 ? 0.0f : (float)filledSlots / (float)this.slotCount;
        if (percent <= 0.33f) {
            return ChatFormatting.GREEN;
        }
        if (percent <= 0.66f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }
}

