/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.consumable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LegacyConsumableItem
extends Item {
    private final Supplier<Item> containerSupplier;
    private final List<String> tooltipKeys;
    private final List<LegacyEffect> effects;
    private final BiConsumer<Level, LivingEntity> customAction;
    private final UseAnim useAnimation;
    private final int useDuration;

    private LegacyConsumableItem(Item.Properties properties, @Nullable Supplier<Item> containerSupplier, List<String> tooltipKeys, List<LegacyEffect> effects, @Nullable BiConsumer<Level, LivingEntity> customAction, UseAnim useAnimation, int useDuration) {
        super(properties);
        this.containerSupplier = containerSupplier;
        this.tooltipKeys = tooltipKeys;
        this.effects = effects;
        this.customAction = customAction;
        this.useAnimation = useAnimation;
        this.useDuration = useDuration;
    }

    public static Builder builder(int nutrition, float saturation) {
        return new Builder(nutrition, saturation);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        for (String key : this.tooltipKeys) {
            if (key == null || key.isEmpty()) continue;
            tooltip.add((Component)Component.m_237115_((String)key).m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.useAnimation;
    }

    public int m_8105_(ItemStack stack) {
        return this.useDuration;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack result = super.m_5922_(stack, level, entity);
        if (!level.f_46443_) {
            this.applyEffects(level, entity);
            if (this.customAction != null) {
                this.customAction.accept(level, entity);
            }
        }
        return this.handleContainerReturn(result, entity);
    }

    private void applyEffects(Level level, LivingEntity entity) {
        for (LegacyEffect effect : this.effects) {
            if (effect.chance <= 0.0f || !(level.f_46441_.m_188501_() <= effect.chance)) continue;
            entity.m_7292_(new MobEffectInstance(effect.effect().get(), effect.duration(), effect.amplifier()));
        }
    }

    private ItemStack handleContainerReturn(ItemStack stack, LivingEntity entity) {
        if (this.containerSupplier == null) {
            return stack;
        }
        Item container = this.containerSupplier.get();
        if (stack.m_41619_()) {
            return new ItemStack((ItemLike)container);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                ItemStack remainder = new ItemStack((ItemLike)container);
                if (!player.m_150109_().m_36054_(remainder)) {
                    player.m_36176_(remainder, false);
                }
            }
        }
        return stack;
    }

    public static class Builder {
        private final FoodProperties.Builder foodBuilder;
        private final Item.Properties itemProperties;
        private Supplier<Item> containerSupplier;
        private final List<String> tooltipKeys = new ArrayList<String>();
        private final List<LegacyEffect> effects = new ArrayList<LegacyEffect>();
        private BiConsumer<Level, LivingEntity> customAction;
        private UseAnim useAnimation = UseAnim.EAT;
        private int useDuration = 32;

        private Builder(int nutrition, float saturation) {
            this.foodBuilder = new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation);
            this.itemProperties = new Item.Properties();
        }

        public Builder meat() {
            this.foodBuilder.m_38757_();
            return this;
        }

        public Builder alwaysEat() {
            this.foodBuilder.m_38765_();
            return this;
        }

        public Builder container(Supplier<Item> supplier) {
            this.containerSupplier = supplier;
            return this;
        }

        public Builder tooltip(String ... keys) {
            Collections.addAll(this.tooltipKeys, keys);
            return this;
        }

        public Builder effect(Supplier<MobEffect> effect, int duration, int amplifier, float chance) {
            this.effects.add(new LegacyEffect(effect, duration, amplifier, chance));
            return this;
        }

        public Builder customAction(BiConsumer<Level, LivingEntity> handler) {
            this.customAction = handler;
            return this;
        }

        public Builder stacksTo(int size) {
            this.itemProperties.m_41487_(size);
            return this;
        }

        public Builder useAnimation(UseAnim animation) {
            this.useAnimation = animation;
            return this;
        }

        public Builder useDuration(int duration) {
            this.useDuration = duration;
            return this;
        }

        public LegacyConsumableItem build() {
            Item.Properties props = this.itemProperties.m_41489_(this.foodBuilder.m_38767_());
            return new LegacyConsumableItem(props, this.containerSupplier, List.copyOf(this.tooltipKeys), List.copyOf(this.effects), this.customAction, this.useAnimation, this.useDuration);
        }
    }

    public record LegacyEffect(Supplier<MobEffect> effect, int duration, int amplifier, float chance) {
    }
}

