/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.consumable;

import com.hbm.item.CreativeTabVariantItem;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;

public class TemFlakesItem
extends Item
implements CreativeTabVariantItem {
    private static final String TAG_VARIANT = "Variant";

    public TemFlakesItem() {
        super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38767_()));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.EAT;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack result = super.m_5922_(stack, level, entity);
        if (!level.f_46443_) {
            entity.m_5634_(2.0f);
        }
        return result;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        Variant variant = TemFlakesItem.getVariant(stack);
        tooltip.add((Component)Component.m_237115_((String)variant.descriptionKey()).m_130940_(ChatFormatting.GRAY));
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        TemFlakesItem.setVariant(stack, Variant.DISCOUNT);
        return stack;
    }

    @Override
    public void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        for (Variant variant : EnumSet.allOf(Variant.class)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            TemFlakesItem.setVariant(stack, variant);
            event.getEntries().put((Object)stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private static void setVariant(ItemStack stack, Variant variant) {
        stack.m_41784_().m_128405_(TAG_VARIANT, variant.id);
    }

    private static Variant getVariant(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_VARIANT)) {
            return Variant.byId(tag.m_128451_(TAG_VARIANT));
        }
        return Variant.DISCOUNT;
    }

    public static enum Variant {
        DISCOUNT(0, "item.hbm.tem_flakes.desc.discount"),
        NORMAL(1, "item.hbm.tem_flakes.desc.normal"),
        EXPENSIVE(2, "item.hbm.tem_flakes.desc.expensive");

        private final int id;
        private final String descriptionKey;

        private Variant(int id, String descriptionKey) {
            this.id = id;
            this.descriptionKey = descriptionKey;
        }

        public static Variant byId(int id) {
            for (Variant variant : Variant.values()) {
                if (variant.id != id) continue;
                return variant;
            }
            return DISCOUNT;
        }

        public String descriptionKey() {
            return this.descriptionKey;
        }
    }
}

