/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.icf;

import com.hbm.Inventory.fluid.ModFluids;
import com.hbm.item.HBMComponent;
import com.hbm.item.HBMItems;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemICFPellet
extends Item {
    public static final String TAG_TYPE_ONE = "type1";
    public static final String TAG_TYPE_TWO = "type2";
    public static final String TAG_MUON = "muon";
    public static final String TAG_DEPLETION = "depletion";
    private static final long BASE_DEPLETION = 50000000000L;
    private static final long BASE_FUSING_DIFFICULTY = 10000000L;
    private static final Map<FuelType, List<Supplier<? extends ItemLike>>> FUEL_SOURCES = new EnumMap<FuelType, List<Supplier<? extends ItemLike>>>(FuelType.class);
    private static final Map<FuelType, List<Supplier<? extends Fluid>>> FLUID_SOURCES = new EnumMap<FuelType, List<Supplier<? extends Fluid>>>(FuelType.class);

    public ItemICFPellet(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public static FuelType getFuel(ItemStack stack, boolean primary) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return primary ? FuelType.DEUTERIUM : FuelType.TRITIUM;
        }
        byte idx = tag.m_128445_(primary ? TAG_TYPE_ONE : TAG_TYPE_TWO);
        return FuelType.fromIndex(idx);
    }

    public static void setFuelTypes(ItemStack stack, FuelType primary, FuelType secondary, boolean muonCatalysed) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128344_(TAG_TYPE_ONE, (byte)primary.ordinal());
        tag.m_128344_(TAG_TYPE_TWO, (byte)secondary.ordinal());
        tag.m_128379_(TAG_MUON, muonCatalysed);
        tag.m_128356_(TAG_DEPLETION, 0L);
    }

    public static ItemStack createStack(FuelType primary, FuelType secondary, boolean muon) {
        ItemStack stack = new ItemStack((ItemLike)HBMItems.icf_pellet.get());
        ItemICFPellet.setFuelTypes(stack, primary, secondary, muon);
        return stack;
    }

    public static long getMaxDepletion(ItemStack stack) {
        FuelType primary = ItemICFPellet.getFuel(stack, true);
        FuelType secondary = ItemICFPellet.getFuel(stack, false);
        double value = 5.0E10;
        value /= primary.depletionSpeed;
        return (long)(value /= secondary.depletionSpeed);
    }

    public static long getDepletion(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0L;
        }
        return tag.m_128454_(TAG_DEPLETION);
    }

    public static void setDepletion(ItemStack stack, long value) {
        stack.m_41784_().m_128356_(TAG_DEPLETION, Math.max(0L, value));
    }

    public static boolean isMuonCatalysed(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(TAG_MUON);
    }

    public static long getFusingDifficulty(ItemStack stack) {
        FuelType primary = ItemICFPellet.getFuel(stack, true);
        FuelType secondary = ItemICFPellet.getFuel(stack, false);
        double difficulty = 1.0E7;
        difficulty *= primary.fusingDifficulty;
        difficulty *= secondary.fusingDifficulty;
        if (ItemICFPellet.isMuonCatalysed(stack)) {
            difficulty /= 4.0;
        }
        return (long)difficulty;
    }

    public static long react(ItemStack stack, long laserInput) {
        if (laserInput <= 0L) {
            return 0L;
        }
        FuelType primary = ItemICFPellet.getFuel(stack, true);
        FuelType secondary = ItemICFPellet.getFuel(stack, false);
        long produced = (long)((double)laserInput * primary.reactionMultiplier * secondary.reactionMultiplier);
        long depletion = ItemICFPellet.getDepletion(stack) + laserInput;
        ItemICFPellet.setDepletion(stack, depletion);
        return produced;
    }

    public static boolean isSpent(ItemStack stack) {
        return ItemICFPellet.getDepletion(stack) >= ItemICFPellet.getMaxDepletion(stack);
    }

    public static int getFuelColor(ItemStack stack) {
        FuelType primary = ItemICFPellet.getFuel(stack, true);
        FuelType secondary = ItemICFPellet.getFuel(stack, false);
        int r = (((primary.color & 0xFF0000) >> 16) + ((secondary.color & 0xFF0000) >> 16)) / 2;
        int g = (((primary.color & 0xFF00) >> 8) + ((secondary.color & 0xFF00) >> 8)) / 2;
        int b = ((primary.color & 0xFF) + (secondary.color & 0xFF)) / 2;
        return r << 16 | g << 8 | b;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return ItemICFPellet.getFuelColor(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        long max = Math.max(1L, ItemICFPellet.getMaxDepletion(stack));
        long depletion = Math.max(0L, Math.min(max, ItemICFPellet.getDepletion(stack)));
        double ratio = 1.0 - (double)depletion / (double)max;
        return Math.max(1, (int)Math.round(13.0 * ratio));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        FuelType primary = ItemICFPellet.getFuel(stack, true);
        FuelType secondary = ItemICFPellet.getFuel(stack, false);
        long max = ItemICFPellet.getMaxDepletion(stack);
        long depletion = ItemICFPellet.getDepletion(stack);
        double pct = max <= 0L ? 0.0 : (double)depletion * 100.0 / (double)max;
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GREEN) + "Depletion: " + String.valueOf(ChatFormatting.RESET) + String.format(Locale.ROOT, "%.1f%%", pct))));
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + "Fuel: " + String.valueOf(ChatFormatting.RESET) + primary.name().toLowerCase(Locale.ROOT) + " / " + secondary.name().toLowerCase(Locale.ROOT))));
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + "Difficulty: " + String.valueOf(ChatFormatting.RESET) + String.format(Locale.ROOT, "%,d TU", ItemICFPellet.getFusingDifficulty(stack)))));
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GOLD) + "Reactivity: " + String.valueOf(ChatFormatting.RESET) + String.format(Locale.ROOT, "x%.2f", primary.reactionMultiplier * secondary.reactionMultiplier))));
        if (ItemICFPellet.isMuonCatalysed(stack)) {
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_AQUA) + "Muon catalysed")));
        }
    }

    public static boolean isSupportedFuel(FuelType type) {
        boolean hasItems = FUEL_SOURCES.containsKey((Object)type) && !FUEL_SOURCES.get((Object)type).isEmpty();
        boolean hasFluids = FLUID_SOURCES.containsKey((Object)type) && !FLUID_SOURCES.get((Object)type).isEmpty();
        return hasItems || hasFluids;
    }

    @Nullable
    public static FuelType fuelFromStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (Map.Entry<FuelType, List<Supplier<? extends ItemLike>>> entry : FUEL_SOURCES.entrySet()) {
            for (Supplier<? extends ItemLike> supplier : entry.getValue()) {
                ItemLike like = supplier.get();
                if (!stack.m_150930_(like.m_5456_())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @Nullable
    public static FuelType fuelFromFluid(FluidStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        for (Map.Entry<FuelType, List<Supplier<? extends Fluid>>> entry : FLUID_SOURCES.entrySet()) {
            for (Supplier<? extends Fluid> supplier : entry.getValue()) {
                Fluid fluid = supplier.get();
                if (!stack.getFluid().m_6212_(fluid)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static List<ItemStack> getFuelItems(FuelType type) {
        List<Supplier<? extends ItemLike>> suppliers = FUEL_SOURCES.get((Object)type);
        if (suppliers == null || suppliers.isEmpty()) {
            return List.of();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Supplier<? extends ItemLike> supplier : suppliers) {
            ItemLike like = supplier.get();
            stacks.add(new ItemStack(like));
        }
        return stacks;
    }

    public static List<ItemStack> getFluidDisplays(FuelType type) {
        List<Supplier<? extends Fluid>> suppliers = FLUID_SOURCES.get((Object)type);
        if (suppliers == null || suppliers.isEmpty()) {
            return List.of();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Supplier<? extends Fluid> supplier : suppliers) {
            Fluid fluid = supplier.get();
            if (fluid.m_6859_() == null) continue;
            stacks.add(new ItemStack((ItemLike)fluid.m_6859_()));
        }
        return stacks;
    }

    private static void registerFuel(FuelType type, Supplier<? extends ItemLike> ... sources) {
        List list = FUEL_SOURCES.computeIfAbsent(type, key -> new ArrayList());
        list.addAll(List.of(sources));
    }

    private static void registerFluid(FuelType type, Supplier<? extends Fluid> ... fluids) {
        List list = FLUID_SOURCES.computeIfAbsent(type, key -> new ArrayList());
        list.addAll(List.of(fluids));
    }

    static {
        ItemICFPellet.registerFuel(FuelType.DEUTERIUM, new Supplier[]{HBMComponent.CELL_DEUTERIUM});
        ItemICFPellet.registerFuel(FuelType.TRITIUM, new Supplier[]{HBMComponent.CELL_TRITIUM});
        ItemICFPellet.registerFluid(FuelType.HYDROGEN, new Supplier[]{ModFluids.HYDROGEN.source()});
        ItemICFPellet.registerFluid(FuelType.DEUTERIUM, new Supplier[]{ModFluids.DEUTERIUM.source()});
        ItemICFPellet.registerFluid(FuelType.TRITIUM, new Supplier[]{ModFluids.TRITIUM.source()});
        ItemICFPellet.registerFluid(FuelType.HELIUM3, new Supplier[]{ModFluids.HELIUM3.source()});
        ItemICFPellet.registerFluid(FuelType.HELIUM4, new Supplier[]{ModFluids.HELIUM4.source()});
        ItemICFPellet.registerFluid(FuelType.OXYGEN, new Supplier[]{ModFluids.OXYGEN.source()});
        ItemICFPellet.registerFluid(FuelType.CHLORINE, new Supplier[]{ModFluids.CHLORINE.source()});
        ItemICFPellet.registerFuel(FuelType.LITHIUM, new Supplier[]{HBMItems.LITHIUM});
        ItemICFPellet.registerFuel(FuelType.BERYLLIUM, new Supplier[]{HBMItems.INGOT_BERYLLIUM});
        ItemICFPellet.registerFuel(FuelType.BORON, new Supplier[]{HBMItems.INGOT_BORON});
        ItemICFPellet.registerFuel(FuelType.CARBON, new Supplier[]{HBMItems.INGOT_GRAPHITE});
        ItemICFPellet.registerFuel(FuelType.SODIUM, new Supplier[]{HBMItems.POWDER_SODIUM});
        ItemICFPellet.registerFuel(FuelType.CHLORINE, new Supplier[]{HBMComponent.CHLORINE_PINWHEEL});
        ItemICFPellet.registerFuel(FuelType.CALCIUM, new Supplier[]{HBMItems.INGOT_CALCIUM});
    }

    public static enum FuelType {
        HYDROGEN(0x4040FF, 1.0, 0.85, 1.0),
        DEUTERIUM(2631883, 1.25, 1.0, 1.0),
        TRITIUM(146, 1.5, 1.0, 1.05),
        HELIUM3(0xFFF09F, 1.75, 1.0, 1.25),
        HELIUM4(16751456, 2.0, 1.0, 1.5),
        LITHIUM(0xE9E9E9, 1.25, 0.85, 2.0),
        BERYLLIUM(10984832, 2.0, 1.0, 2.5),
        BORON(6913929, 3.0, 0.5, 3.5),
        CARBON(0x454545, 2.0, 1.0, 5.0),
        OXYGEN(11854591, 1.25, 1.5, 7.5),
        SODIUM(14673127, 3.0, 0.75, 8.75),
        CHLORINE(14345624, 2.5, 1.0, 10.0),
        CALCIUM(13813673, 3.0, 1.0, 12.5);

        public final int color;
        public final double reactionMultiplier;
        public final double depletionSpeed;
        public final double fusingDifficulty;

        private FuelType(int color, double reactionMultiplier, double depletionSpeed, double fusingDifficulty) {
            this.color = color;
            this.reactionMultiplier = reactionMultiplier;
            this.depletionSpeed = depletionSpeed;
            this.fusingDifficulty = fusingDifficulty;
        }

        public static FuelType fromIndex(int index) {
            FuelType[] values = FuelType.values();
            if (index < 0 || index >= values.length) {
                return DEUTERIUM;
            }
            return values[index];
        }
    }
}

