/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.pwr;

import com.hbm.reactor.pwr.PWRFuelType;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemPWRFuel
extends Item {
    public static final String TAG_FUEL_TYPE = "pwrType";
    private final FuelState state;

    public ItemPWRFuel(Item.Properties properties, FuelState state) {
        super(properties);
        this.state = state;
    }

    public FuelState getState() {
        return this.state;
    }

    public static int getFuelTypeIndex(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_FUEL_TYPE)) {
            return 0;
        }
        return tag.m_128451_(TAG_FUEL_TYPE);
    }

    public static PWRFuelType getFuelType(ItemStack stack) {
        return PWRFuelType.fromIndex(ItemPWRFuel.getFuelTypeIndex(stack));
    }

    public static void setFuelType(ItemStack stack, PWRFuelType type) {
        stack.m_41784_().m_128405_(TAG_FUEL_TYPE, type.ordinal());
    }

    public static ItemStack createStack(Item item, PWRFuelType type) {
        ItemStack stack = new ItemStack((ItemLike)item);
        ItemPWRFuel.setFuelType(stack, type);
        return stack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFreshFuel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ItemPWRFuel)) return false;
        ItemPWRFuel fuel = (ItemPWRFuel)item;
        if (fuel.state != FuelState.FRESH) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHotFuel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ItemPWRFuel)) return false;
        ItemPWRFuel fuel = (ItemPWRFuel)item;
        if (fuel.state != FuelState.HOT) return false;
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        PWRFuelType type = ItemPWRFuel.getFuelType(stack);
        String color = ChatFormatting.GOLD.toString();
        String reset = ChatFormatting.RESET.toString();
        tooltip.add((Component)Component.m_237113_((String)(color + "Heat per flux: " + reset + String.format(Locale.ROOT, "%.1f", type.heatEmission) + " TU")));
        tooltip.add((Component)Component.m_237113_((String)(color + "Reaction function: " + reset + type.getFunctionLabel())));
        tooltip.add((Component)Component.m_237113_((String)(color + "Fuel type: " + reset + type.getDangerLabel())));
    }

    public static enum FuelState {
        FRESH,
        HOT,
        DEPLETED;

    }
}

