/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.research;

import com.hbm.item.HBMItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBreedingRod
extends Item {
    private static final String TAG_TYPE = "hbmRodType";
    private final RodForm form;

    public ItemBreedingRod(Item.Properties properties, RodForm form) {
        super(properties.m_41487_(1));
        this.form = form;
    }

    public RodForm getForm() {
        return this.form;
    }

    public static ItemStack createStack(RodForm form, RodType type) {
        Item item = switch (form) {
            default -> throw new IncompatibleClassChangeError();
            case RodForm.SINGLE -> (Item)HBMItems.rod_breeder_single.get();
            case RodForm.DUAL -> (Item)HBMItems.rod_breeder_dual.get();
            case RodForm.QUAD -> (Item)HBMItems.rod_breeder_quad.get();
        };
        ItemStack stack = new ItemStack((ItemLike)item);
        ItemBreedingRod.setType(stack, type);
        return stack;
    }

    public static void setType(ItemStack stack, RodType type) {
        stack.m_41784_().m_128344_(TAG_TYPE, (byte)type.ordinal());
    }

    public static RodType getType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return RodType.LITHIUM;
        }
        return RodType.byOrdinal(tag.m_128445_(TAG_TYPE));
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + "[Breeder Rod]")));
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + " Type: " + ItemBreedingRod.getType(stack).displayName())));
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + " Form: " + this.form.displayName())));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return false;
    }

    public static enum RodForm {
        SINGLE("Single"),
        DUAL("Dual"),
        QUAD("Quad");

        private final String name;

        private RodForm(String name) {
            this.name = name;
        }

        public String displayName() {
            return this.name;
        }
    }

    public static enum RodType {
        LITHIUM,
        TRITIUM,
        CO,
        CO60,
        TH232,
        THF,
        U235,
        NP237,
        U238,
        PU238,
        PU239,
        RGP,
        WASTE,
        LEAD,
        URANIUM,
        RA226,
        AC227;

        private static final RodType[] VALUES;

        public static RodType byOrdinal(int idx) {
            if (idx < 0 || idx >= VALUES.length) {
                return LITHIUM;
            }
            return VALUES[idx];
        }

        public String displayName() {
            String base = this.name().toLowerCase();
            return base.substring(0, 1).toUpperCase() + base.substring(1);
        }

        static {
            VALUES = RodType.values();
        }
    }
}

