/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.research;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemPileRod
extends Item {
    public static final String TAG_LIFE = "hbmPileLife";
    private final Spec spec;

    public ItemPileRod(Item.Properties properties, Spec spec) {
        super(properties.m_41487_(1));
        this.spec = spec;
    }

    public Spec getSpec() {
        return this.spec;
    }

    public int getLifetime(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(TAG_LIFE) : 0;
    }

    public void addLifetime(ItemStack stack, int amount) {
        if (amount <= 0) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int next = Math.min(this.spec.maxLife(), tag.m_128451_(TAG_LIFE) + amount);
        tag.m_128405_(TAG_LIFE, next);
    }

    public boolean isSpent(ItemStack stack) {
        return this.spec.maxLife() > 0 && this.getLifetime(stack) >= this.spec.maxLife();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + "Flux: " + String.valueOf(ChatFormatting.WHITE) + ItemPileRod.format(this.spec.fluxPerTick()) + " n/t")));
        if (this.spec.heatPerTick() != 0.0) {
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GOLD) + "Heat: " + String.valueOf(ChatFormatting.WHITE) + ItemPileRod.format(this.spec.heatPerTick()) + " kHE/t")));
        }
        if (this.spec.controlEffect() != 0.0) {
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + "Control: " + String.valueOf(ChatFormatting.WHITE) + ItemPileRod.format(this.spec.controlEffect() * 100.0) + "%")));
        }
        if (this.spec.breederInput()) {
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GREEN) + "Breeder ingredient")));
        }
        if (this.spec.maxLife() > 0) {
            int life = this.getLifetime(stack);
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "Wear: " + life + " / " + this.spec.maxLife())));
        }
    }

    private static String format(double value) {
        if (Math.abs(value) < 0.01) {
            return "0";
        }
        return String.format("%.1f", value);
    }

    public record Spec(double fluxPerTick, double heatPerTick, double controlEffect, int maxLife, int wearPerTick, boolean breederInput) {
        public Spec {
            if (maxLife < 0) {
                maxLife = 0;
            }
            if (wearPerTick <= 0) {
                wearPerTick = 1;
            }
        }

        public static Spec fuel(double flux, double heat, int maxLife, int wear) {
            return new Spec(flux, heat, 0.0, maxLife, wear, false);
        }

        public static Spec control(double controlEffect, int maxLife, int wear) {
            return new Spec(0.0, 0.0, controlEffect, maxLife, wear, false);
        }

        public static Spec source(double flux, double heat, int maxLife, int wear) {
            return new Spec(flux, heat, 0.0, maxLife, wear, false);
        }

        public static Spec breeder(int maxLife) {
            return new Spec(0.0, 0.0, 0.0, maxLife, 1, true);
        }
    }
}

