/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.research;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemResearchFuelPlate
extends Item {
    private static final String TAG_LIFE = "hbmPlateLife";
    private final int lifeTime;
    private final FunctionType functionType;
    private final int reactivity;

    public ItemResearchFuelPlate(Item.Properties properties, int lifeTime, FunctionType functionType, int reactivity) {
        super(properties.m_41487_(1));
        this.lifeTime = lifeTime;
        this.functionType = functionType;
        this.reactivity = reactivity;
    }

    public int react(ItemStack stack, int incomingFlux) {
        if (this.functionType != FunctionType.PASSIVE) {
            this.addLifetime(stack, incomingFlux);
        }
        return switch (this.functionType) {
            default -> throw new IncompatibleClassChangeError();
            case FunctionType.LOGARITHM -> (int)(Math.log10(incomingFlux + 1) * 0.5 * (double)this.reactivity);
            case FunctionType.SQUARE_ROOT -> (int)(Math.sqrt(incomingFlux) * (double)this.reactivity / 10.0);
            case FunctionType.NEGATIVE_QUADRATIC -> (int)Math.max(((double)incomingFlux - (double)(incomingFlux * incomingFlux) / 10000.0) / 100.0 * (double)this.reactivity, 0.0);
            case FunctionType.LINEAR -> (int)((double)incomingFlux / 100.0 * (double)this.reactivity);
            case FunctionType.PASSIVE -> {
                this.addLifetime(stack, this.reactivity);
                yield this.reactivity;
            }
        };
    }

    public boolean isSpent(ItemStack stack) {
        return this.getLifetime(stack) >= this.lifeTime;
    }

    private int getLifetime(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_(TAG_LIFE) : 0;
    }

    private void addLifetime(ItemStack stack, int delta) {
        if (delta <= 0) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int next = Math.min(this.lifeTime, tag.m_128451_(TAG_LIFE) + delta);
        tag.m_128405_(TAG_LIFE, next);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        if (this.lifeTime <= 0) {
            return 13;
        }
        double pct = 1.0 - (double)this.getLifetime(stack) / (double)this.lifeTime;
        return Math.max(1, (int)Math.round(pct * 13.0));
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return 3866434;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + "[Research Reactor Plate]")));
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_AQUA) + "   " + this.getFunctionDescription())));
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_AQUA) + "   Yield of " + ItemResearchFuelPlate.formatNumber(this.lifeTime) + " events")));
    }

    private String getFunctionDescription() {
        return switch (this.functionType) {
            default -> throw new IncompatibleClassChangeError();
            case FunctionType.LOGARITHM -> "f(x) = log10(x + 1) * 0.5 * " + this.reactivity;
            case FunctionType.SQUARE_ROOT -> "f(x) = sqrt(x) * " + this.reactivity + " / 10";
            case FunctionType.NEGATIVE_QUADRATIC -> "f(x) = [x - (x\u00b2 / 10000)] / 100 * " + this.reactivity;
            case FunctionType.LINEAR -> "f(x) = x / 100 * " + this.reactivity;
            case FunctionType.PASSIVE -> "f(x) = " + this.reactivity;
        };
    }

    private static String formatNumber(int value) {
        if (value < 1000) {
            return Integer.toString(value);
        }
        return String.format("%.1fk", (double)value / 1000.0);
    }

    public static enum FunctionType {
        LOGARITHM,
        SQUARE_ROOT,
        NEGATIVE_QUADRATIC,
        LINEAR,
        PASSIVE;

    }
}

