/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.tool;

import com.hbm.HBMLang;
import com.hbm.api.energy.ItemStackEnergyHandler;
import com.hbm.api.energy.fe.HBMEnergyStorage;
import com.hbm.block.machine.BlockBattery;
import com.hbm.blockentity.ModBlockEntityType;
import com.hbm.capabilities.ItemCapabilityWrapper;
import com.hbm.item.BlockItemHBM;
import com.hbm.utils.ItemDataUtils;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class BatteryBlockItem
extends BlockItemHBM {
    long capacity;
    long inout;
    boolean isEmpty;
    static int DEFAULT_DAMAGE = 1000;

    public BatteryBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties.m_41499_(DEFAULT_DAMAGE));
        this.capacity = ((BlockBattery)pBlock).type.getMaxEnergy();
        this.inout = ((BlockBattery)pBlock).type.getOutput();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237110_((String)HBMLang.ENERGY.key(), (Object[])new Object[]{BatteryBlockItem.getEnergy(pStack)}));
    }

    @Override
    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        super.gatherCapabilities(capabilities, stack, nbt);
        capabilities.add(new ItemStackEnergyHandler(this.capacity, this.inout, true));
    }

    public static long getEnergy(ItemStack pStack) {
        long result = 0L;
        IEnergyStorage iEnergyStorage = (IEnergyStorage)pStack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
        if (iEnergyStorage instanceof HBMEnergyStorage) {
            HBMEnergyStorage energyStorage = (HBMEnergyStorage)iEnergyStorage;
            result = energyStorage.getEnergyStored();
        }
        return result;
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult m_40576_(BlockPlaceContext pContext) {
        ItemStack itemInHand = pContext.m_43722_();
        CompoundTag dataMapIfPresent = ItemDataUtils.getDataMapIfPresent(itemInHand);
        if (dataMapIfPresent != null) {
            BatteryBlockItem.m_186338_((ItemStack)itemInHand, (BlockEntityType)((BlockEntityType)ModBlockEntityType.BATTERY_ENTITY.get()), (CompoundTag)dataMapIfPresent);
        }
        return super.m_40576_(pContext);
    }
}

