/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.tool;

import com.hbm.HBMLang;
import com.hbm.api.energy.IEnergyHandler;
import com.hbm.api.energy.ItemStackEnergyHandler;
import com.hbm.capabilities.HBMCaps;
import com.hbm.capabilities.ItemCapabilityWrapper;
import com.hbm.item.CapabilityItem;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BatteryItem
extends CapabilityItem {
    long capacity;
    long inout;
    boolean isEmpty;
    public static int DEFAULT_DAMAGE = 1000;

    public BatteryItem(long capacity, long inout, Item.Properties pProperties) {
        super(pProperties.m_41499_(DEFAULT_DAMAGE));
        this.capacity = capacity;
        this.inout = inout;
    }

    public BatteryItem(boolean isEmpty, long capacity, long inout, Item.Properties pProperties) {
        super(pProperties.m_41503_(DEFAULT_DAMAGE));
        this.capacity = capacity;
        this.inout = inout;
        this.isEmpty = isEmpty;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237110_((String)HBMLang.ENERGY.key(), (Object[])new Object[]{BatteryItem.getEnergy(pStack)}));
    }

    public static long getEnergy(ItemStack pStack) {
        long result = 0L;
        IEnergyHandler energyHandler = (IEnergyHandler)pStack.getCapability(HBMCaps.LONG_ENERGY).orElse(null);
        if (energyHandler != null) {
            result = energyHandler.getStored();
        }
        return result;
    }

    @Override
    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        super.gatherCapabilities(capabilities, stack, nbt);
        capabilities.add(new ItemStackEnergyHandler(this.capacity, this.inout, this.isEmpty));
    }

    public boolean m_142522_(ItemStack pStack) {
        return this.capacity > 0L && BatteryItem.getEnergy(pStack) < this.capacity;
    }
}

