/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.tool;

import com.hbm.blockentity.machine.pile.ChicagoBreederBlockEntity;
import com.hbm.blockentity.machine.pile.ChicagoDetectorBlockEntity;
import com.hbm.blockentity.machine.pile.ChicagoFuelBlockEntity;
import com.hbm.blockentity.machine.pile.ChicagoPileBlockEntity;
import com.hbm.blockentity.machine.pile.ChicagoSourceBlockEntity;
import com.hbm.item.HBMItems;
import com.hbm.registries.ModBlocks;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class HandDrillItem
extends Item {
    private final boolean damageOnUse;

    public HandDrillItem(int durability) {
        super(HandDrillItem.withDurability(durability));
        this.damageOnUse = durability > 0;
    }

    private static Item.Properties withDurability(int durability) {
        Item.Properties properties = new Item.Properties().m_41487_(1);
        return durability > 0 ? properties.m_41503_(durability) : properties;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult inspect = this.probeChicago(context);
        if (inspect.m_19077_()) {
            return inspect;
        }
        InteractionResult result = this.drillGraphite(context);
        if (result.m_19077_() && !context.m_43725_().f_46443_) {
            this.damageDrill(context);
        }
        return result;
    }

    private InteractionResult drillGraphite(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (!state.m_60713_((Block)ModBlocks.chicago_graphite_block.get())) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            Direction.Axis axis = context.m_43719_() != null ? context.m_43719_().m_122434_() : Direction.Axis.Y;
            BlockState target = (BlockState)((Block)ModBlocks.chicago_graphite_drilled.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis);
            level.m_7731_(pos, target, 3);
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)HBMItems.INGOT_GRAPHITE.get()));
            SoundType sound = state.getSoundType((LevelReader)level, pos, (Entity)context.m_43723_());
            level.m_5594_(null, pos, sound.m_56775_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
            level.m_142346_((Entity)context.m_43723_(), GameEvent.f_157792_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private InteractionResult probeChicago(UseOnContext context) {
        Component message;
        Level level = context.m_43725_();
        BlockEntity blockEntity = level.m_7702_(context.m_8083_());
        if (!(blockEntity instanceof ChicagoPileBlockEntity)) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_ && (message = this.describeChicago(blockEntity)) != null) {
            player.m_5661_(message, true);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private Component describeChicago(BlockEntity entity) {
        if (entity instanceof ChicagoFuelBlockEntity) {
            ChicagoFuelBlockEntity fuel = (ChicagoFuelBlockEntity)entity;
            return this.describeFuel(fuel);
        }
        if (entity instanceof ChicagoSourceBlockEntity) {
            ChicagoSourceBlockEntity source = (ChicagoSourceBlockEntity)entity;
            return this.describeSource(source);
        }
        if (entity instanceof ChicagoBreederBlockEntity) {
            ChicagoBreederBlockEntity breeder = (ChicagoBreederBlockEntity)entity;
            return this.describeBreeder(breeder);
        }
        if (entity instanceof ChicagoDetectorBlockEntity) {
            ChicagoDetectorBlockEntity detector = (ChicagoDetectorBlockEntity)entity;
            return this.describeDetector(detector);
        }
        return Component.m_237115_((String)"message.hbm.chicago.status.unknown");
    }

    private Component describeFuel(ChicagoFuelBlockEntity fuel) {
        ChicagoFuelBlockEntity.FuelVariant variant = fuel.getVariant();
        if (variant == null) {
            return Component.m_237115_((String)"message.hbm.chicago.status.fuel_empty");
        }
        ItemStack rodStack = new ItemStack((ItemLike)variant.item.get());
        int life = fuel.getRodLife();
        int maxLife = variant.maxLife;
        double heat = fuel.getHeatLevel();
        double meltdown = fuel.getMeltdownHeat();
        double wearPercent = maxLife > 0 ? (double)life * 100.0 / (double)maxLife : 0.0;
        double heatPercent = meltdown > 0.0 ? heat * 100.0 / meltdown : 0.0;
        return Component.m_237110_((String)"message.hbm.chicago.status.fuel", (Object[])new Object[]{rodStack.m_41786_(), life, maxLife, HandDrillItem.formatPercent(wearPercent), HandDrillItem.formatNumber(heat), HandDrillItem.formatNumber(meltdown), HandDrillItem.formatPercent(heatPercent)});
    }

    private Component describeSource(ChicagoSourceBlockEntity source) {
        ChicagoSourceBlockEntity.SourceType type = source.getSourceType();
        if (type == null) {
            return Component.m_237115_((String)"message.hbm.chicago.status.source_empty");
        }
        ItemStack rodStack = new ItemStack((ItemLike)type.rod().get());
        return Component.m_237110_((String)"message.hbm.chicago.status.source", (Object[])new Object[]{rodStack.m_41786_(), type.fluxPerStream(), type.streams()});
    }

    private Component describeBreeder(ChicagoBreederBlockEntity breeder) {
        if (!breeder.hasRod()) {
            return Component.m_237115_((String)"message.hbm.chicago.status.breeder_empty");
        }
        ItemStack rodStack = breeder.getRodSnapshot();
        int progress = breeder.getProgress();
        int max = breeder.getMaxProgress();
        double percent = max > 0 ? (double)progress * 100.0 / (double)max : 0.0;
        int lastFlux = breeder.getLastNeutrons();
        return Component.m_237110_((String)"message.hbm.chicago.status.breeder", (Object[])new Object[]{rodStack.m_41786_(), progress, max, HandDrillItem.formatPercent(percent), lastFlux});
    }

    private Component describeDetector(ChicagoDetectorBlockEntity detector) {
        if (!detector.hasRod()) {
            return Component.m_237110_((String)"message.hbm.chicago.status.detector_empty", (Object[])new Object[]{detector.getThresholdValue()});
        }
        ItemStack rodStack = detector.getRodSnapshot();
        return Component.m_237110_((String)"message.hbm.chicago.status.detector", (Object[])new Object[]{rodStack.m_41786_(), detector.getThresholdValue()});
    }

    private static String formatNumber(double value) {
        return String.format(Locale.ROOT, "%.1f", value);
    }

    private static String formatPercent(double value) {
        return String.format(Locale.ROOT, "%.1f", value);
    }

    private void damageDrill(UseOnContext context) {
        if (!this.damageOnUse) {
            return;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return;
        }
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack stack = context.m_43722_();
        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
    }
}

