/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.tool;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ItemBuildWand
extends Item {
    public static final String TAG_BLOCK_STATE = "wand_block_state";
    public static final String TAG_UNDO_ROOT = "wand_undo";
    public static final String TAG_UNDO_DIMENSION = "dimension";
    public static final String TAG_UNDO_LIST = "states";
    public static final String TAG_UNDO_POS = "pos";
    public static final String TAG_UNDO_STATE = "state";

    public ItemBuildWand(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm.wand.creative"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm.wand.quote"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm.wand.hint"));
        BlockPos pos = ItemBuildWand.getStoredPos(stack);
        if (pos != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm.wand.pos", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm.wand.pos_missing"));
        }
        BlockState state = ItemBuildWand.getStoredBlockState(stack);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.hbm.wand.block", (Object[])new Object[]{state.m_60734_().m_49954_()}));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos clickedPos = context.m_8083_();
        if (player.m_6144_()) {
            BlockState state = level.m_8055_(clickedPos);
            ItemBuildWand.setStoredBlockState(stack, state);
            player.m_5661_((Component)Component.m_237110_((String)"msg.hbm.wand.block_set", (Object[])new Object[]{state.m_60734_().m_49954_()}), true);
            return InteractionResult.SUCCESS;
        }
        BlockPos storedPos = ItemBuildWand.getStoredPos(stack);
        if (storedPos == null) {
            ItemBuildWand.setStoredPos(stack, clickedPos);
            player.m_5661_((Component)Component.m_237110_((String)"msg.hbm.wand.pos_set", (Object[])new Object[]{clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_()}), true);
            return InteractionResult.SUCCESS;
        }
        BlockState fillState = ItemBuildWand.getStoredBlockState(stack);
        int changed = ItemBuildWand.fillSelection(level, storedPos, clickedPos, fillState, player);
        ItemBuildWand.clearStoredPos(stack);
        player.m_5661_((Component)Component.m_237110_((String)"msg.hbm.wand.fill", (Object[])new Object[]{changed}), true);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6144_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                UndoResult result = ItemBuildWand.undoLast(serverPlayer);
                if (result.status() == UndoStatus.OK) {
                    player.m_5661_((Component)Component.m_237110_((String)"msg.hbm.wand.undo.success", (Object[])new Object[]{result.count()}), true);
                    return InteractionResultHolder.m_19092_((Object)stack, (boolean)false);
                }
                if (result.status() == UndoStatus.MISSING_LEVEL) {
                    player.m_5661_((Component)Component.m_237110_((String)"msg.hbm.wand.undo.dimension_missing", (Object[])new Object[]{result.dimension()}), true);
                    return InteractionResultHolder.m_19092_((Object)stack, (boolean)false);
                }
            }
            ItemBuildWand.setStoredBlockState(stack, Blocks.f_50016_.m_49966_());
            player.m_5661_((Component)Component.m_237110_((String)"msg.hbm.wand.block_set", (Object[])new Object[]{Blocks.f_50016_.m_49954_()}), true);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public static UndoResult undoLast(ServerPlayer player) {
        CompoundTag data = player.getPersistentData();
        if (!data.m_128425_(TAG_UNDO_ROOT, 10)) {
            return new UndoResult(UndoStatus.EMPTY, 0, null);
        }
        CompoundTag undoData = data.m_128469_(TAG_UNDO_ROOT);
        if (!undoData.m_128425_(TAG_UNDO_LIST, 9)) {
            data.m_128473_(TAG_UNDO_ROOT);
            return new UndoResult(UndoStatus.EMPTY, 0, null);
        }
        if (!undoData.m_128425_(TAG_UNDO_DIMENSION, 8)) {
            data.m_128473_(TAG_UNDO_ROOT);
            return new UndoResult(UndoStatus.EMPTY, 0, null);
        }
        String dimensionKey = undoData.m_128461_(TAG_UNDO_DIMENSION);
        if (dimensionKey.isEmpty()) {
            data.m_128473_(TAG_UNDO_ROOT);
            return new UndoResult(UndoStatus.EMPTY, 0, null);
        }
        ResourceLocation dimensionId = new ResourceLocation(dimensionKey);
        ServerLevel level = player.f_8924_.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionId));
        if (level == null) {
            data.m_128473_(TAG_UNDO_ROOT);
            return new UndoResult(UndoStatus.MISSING_LEVEL, 0, dimensionId);
        }
        ListTag list = undoData.m_128437_(TAG_UNDO_LIST, 10);
        int restored = 0;
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            BlockPos pos = BlockPos.m_122022_((long)entry.m_128454_(TAG_UNDO_POS));
            BlockState state = ItemBuildWand.readBlockState(entry.m_128469_(TAG_UNDO_STATE));
            level.m_7731_(pos, state, 3);
            ++restored;
        }
        data.m_128473_(TAG_UNDO_ROOT);
        return new UndoResult(UndoStatus.OK, restored, dimensionId);
    }

    private static int fillSelection(Level level, BlockPos from, BlockPos to, BlockState fillState, Player player) {
        int minX = Math.min(from.m_123341_(), to.m_123341_());
        int minY = Math.min(from.m_123342_(), to.m_123342_());
        int minZ = Math.min(from.m_123343_(), to.m_123343_());
        int maxX = Math.max(from.m_123341_(), to.m_123341_());
        int maxY = Math.max(from.m_123342_(), to.m_123342_());
        int maxZ = Math.max(from.m_123343_(), to.m_123343_());
        ListTag undoList = new ListTag();
        int changed = 0;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    cursor.m_122178_(x, y, z);
                    BlockState current = level.m_8055_((BlockPos)cursor);
                    if (current.equals(fillState)) continue;
                    CompoundTag entry = new CompoundTag();
                    entry.m_128356_(TAG_UNDO_POS, cursor.m_121878_());
                    entry.m_128365_(TAG_UNDO_STATE, (Tag)ItemBuildWand.writeBlockState(current));
                    undoList.add((Object)entry);
                    level.m_7731_((BlockPos)cursor, fillState, 3);
                    ++changed;
                }
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (undoList.isEmpty()) {
                serverPlayer.getPersistentData().m_128473_(TAG_UNDO_ROOT);
            } else {
                ItemBuildWand.storeUndo(serverPlayer, level, undoList);
            }
        }
        return changed;
    }

    private static void storeUndo(ServerPlayer player, Level level, ListTag undoList) {
        CompoundTag undo = new CompoundTag();
        undo.m_128359_(TAG_UNDO_DIMENSION, level.m_46472_().m_135782_().toString());
        undo.m_128365_(TAG_UNDO_LIST, (Tag)undoList);
        player.getPersistentData().m_128365_(TAG_UNDO_ROOT, (Tag)undo);
    }

    private static void setStoredPos(ItemStack stack, BlockPos pos) {
        stack.m_41700_("position", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    private static void clearStoredPos(ItemStack stack) {
        stack.m_41749_("position");
    }

    private static BlockPos getStoredPos(ItemStack stack) {
        CompoundTag posTag = stack.m_41737_("position");
        if (posTag == null) {
            return null;
        }
        return NbtUtils.m_129239_((CompoundTag)posTag);
    }

    private static void setStoredBlockState(ItemStack stack, BlockState state) {
        stack.m_41700_(TAG_BLOCK_STATE, (Tag)ItemBuildWand.writeBlockState(state));
    }

    private static BlockState getStoredBlockState(ItemStack stack) {
        CompoundTag stateTag = stack.m_41737_(TAG_BLOCK_STATE);
        if (stateTag == null || stateTag.m_128456_()) {
            return Blocks.f_50016_.m_49966_();
        }
        return ItemBuildWand.readBlockState(stateTag);
    }

    private static CompoundTag writeBlockState(BlockState state) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Name", BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString());
        CompoundTag propsTag = new CompoundTag();
        for (Map.Entry entry : state.m_61148_().entrySet()) {
            Property property = (Property)entry.getKey();
            propsTag.m_128359_(property.m_61708_(), ItemBuildWand.getPropertyValue(property, (Comparable)entry.getValue()));
        }
        if (!propsTag.m_128456_()) {
            tag.m_128365_("Properties", (Tag)propsTag);
        }
        return tag;
    }

    private static BlockState readBlockState(CompoundTag tag) {
        if (tag == null || !tag.m_128425_("Name", 8)) {
            return Blocks.f_50016_.m_49966_();
        }
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(tag.m_128461_("Name")));
        BlockState state = block.m_49966_();
        if (tag.m_128425_("Properties", 10)) {
            CompoundTag props = tag.m_128469_("Properties");
            for (String key : props.m_128431_()) {
                Property property = block.m_49965_().m_61081_(key);
                if (property == null) continue;
                state = ItemBuildWand.applyProperty(state, property, props.m_128461_(key));
            }
        }
        return state;
    }

    private static BlockState applyProperty(BlockState state, Property property, String value) {
        Optional parsed = property.m_6215_(value);
        if (parsed.isPresent()) {
            return (BlockState)state.m_61124_(property, (Comparable)parsed.get());
        }
        return state;
    }

    private static String getPropertyValue(Property property, Comparable value) {
        return property.m_6940_(value);
    }

    public record UndoResult(UndoStatus status, int count, @Nullable ResourceLocation dimension) {
    }

    public static enum UndoStatus {
        OK,
        EMPTY,
        MISSING_LEVEL;

    }
}

