/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.tool;

import com.hbm.block.machine.rbmk.BlockRBMKBase;
import com.hbm.blockentity.machine.rbmk.RBMKPeripheralEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ItemRBMKTool
extends Item {
    private static final String TAG_TARGET = "LinkedColumn";

    public ItemRBMKTool(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        BlockState state = level.m_8055_(clickedPos);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Block block = state.m_60734_();
        if (block instanceof BlockRBMKBase) {
            BlockRBMKBase baseBlock = (BlockRBMKBase)block;
            BlockPos corePos = baseBlock.getCore(state, (LevelReader)level, clickedPos);
            ItemRBMKTool.saveTarget(stack, corePos);
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"item.hbm.rbmk_tool.linked", (Object[])new Object[]{corePos.m_123341_(), corePos.m_123342_(), corePos.m_123343_()}).m_130940_(ChatFormatting.GREEN), true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockEntity entity = level.m_7702_(clickedPos);
        if (entity instanceof RBMKPeripheralEntity) {
            RBMKPeripheralEntity peripheral = (RBMKPeripheralEntity)entity;
            BlockPos target = ItemRBMKTool.getTarget(stack);
            if (!level.f_46443_) {
                if (target == null) {
                    player.m_5661_((Component)Component.m_237115_((String)"item.hbm.rbmk_tool.target_missing").m_130940_(ChatFormatting.RED), true);
                } else if (peripheral.linkToColumn(target)) {
                    player.m_5661_((Component)Component.m_237110_((String)"item.hbm.rbmk_tool.set", (Object[])new Object[]{target.m_123341_(), target.m_123342_(), target.m_123343_(), peripheral.getPeripheralType().displayName()}).m_130940_(ChatFormatting.GREEN), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"item.hbm.rbmk_tool.invalid", (Object[])new Object[]{target.m_123341_(), target.m_123342_(), target.m_123343_()}).m_130940_(ChatFormatting.RED), true);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.hbm.rbmk_tool.desc1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.hbm.rbmk_tool.desc2").m_130940_(ChatFormatting.GRAY));
        BlockPos target = ItemRBMKTool.getTarget(stack);
        if (target != null) {
            tooltip.add((Component)Component.m_237110_((String)"item.hbm.rbmk_tool.target", (Object[])new Object[]{target.m_123341_(), target.m_123342_(), target.m_123343_()}).m_130940_(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.hbm.rbmk_tool.target_missing").m_130940_(ChatFormatting.RED));
        }
    }

    private static void saveTarget(ItemStack stack, BlockPos pos) {
        stack.m_41784_().m_128356_(TAG_TARGET, pos.m_121878_());
    }

    @Nullable
    private static BlockPos getTarget(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(TAG_TARGET)) {
            return null;
        }
        return BlockPos.m_122022_((long)stack.m_41783_().m_128454_(TAG_TARGET));
    }
}

