/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.weapon;

import com.hbm.HBMLang;
import com.hbm.entity.weapon.missile.EntityMissile;
import com.hbm.item.weapon.ItemCustomLore;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.Model;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemMissile
extends ItemCustomLore {
    public final MissileFormFactor formFactor;
    public final MissileTier tier;
    public final MissileFuel fuel;
    public int fuelCap;
    public boolean launchable = true;
    public EntityMissile.MissileCreator missileCreator;
    public Supplier<Model> model = null;

    public ItemMissile(Item.Properties pProperties, MissileFormFactor form, MissileTier tier, EntityMissile.MissileCreator missileCreator) {
        this(pProperties.m_41487_(1), form, tier, form.defaultFuel, missileCreator);
    }

    public ItemMissile(Item.Properties pProperties, MissileFormFactor form, MissileTier tier, MissileFuel fuel, EntityMissile.MissileCreator missileCreator) {
        super(pProperties);
        this.formFactor = form;
        this.tier = tier;
        this.fuel = fuel;
        this.setFuelCap(this.fuel.defaultCap);
        this.missileCreator = missileCreator;
    }

    public ItemMissile setModel(Supplier<Model> model) {
        this.model = model;
        return this;
    }

    public ItemMissile notLaunchable() {
        this.launchable = false;
        return this;
    }

    public ItemMissile setFuelCap(int fuelCap) {
        this.fuelCap = fuelCap;
        return this;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        list.add((Component)Component.m_237110_((String)HBMLang.ITEM_MISSILE_TIER.key(), (Object[])new Object[]{this.tier.ordinal()}).m_130940_(ChatFormatting.ITALIC));
        if (!this.launchable) {
            list.add((Component)Component.m_237115_((String)HBMLang.ITEM_MISSILE_DESC_NOTLAUNCHABLE.key()).m_130940_(ChatFormatting.RED));
        } else {
            list.add((Component)Component.m_237115_((String)HBMLang.FUEL.key()).m_130946_(": ").m_7220_(this.fuel.getDisplay()).m_130940_(ChatFormatting.RED));
            if (this.fuelCap > 0) {
                list.add((Component)Component.m_237110_((String)HBMLang.FUEL_CAPACITY.key(), (Object[])new Object[]{this.fuelCap}));
            }
            super.m_7373_(pStack, pLevel, list, pIsAdvanced);
        }
    }

    public static enum MissileFormFactor {
        ABM(MissileFuel.SOLID),
        MICRO(MissileFuel.SOLID),
        V2(MissileFuel.ETHANOL_PEROXIDE),
        STRONG(MissileFuel.KEROSENE_PEROXIDE),
        HUGE(MissileFuel.KEROSENE_LOXY),
        ATLAS(MissileFuel.JETFUEL_LOXY),
        OTHER(MissileFuel.KEROSENE_PEROXIDE);

        protected MissileFuel defaultFuel;

        private MissileFormFactor(MissileFuel defaultFuel) {
            this.defaultFuel = defaultFuel;
        }
    }

    public static enum MissileFuel {
        SOLID("item.missile.fuel.solid.prefueled", ChatFormatting.GOLD, 0),
        ETHANOL_PEROXIDE("item.missile.fuel.ethanol_peroxide", ChatFormatting.AQUA, 4000),
        KEROSENE_PEROXIDE("item.missile.fuel.kerosene_peroxide", ChatFormatting.BLUE, 8000),
        KEROSENE_LOXY("item.missile.fuel.kerosene_loxy", ChatFormatting.LIGHT_PURPLE, 12000),
        JETFUEL_LOXY("item.missile.fuel.jetfuel_loxy", ChatFormatting.RED, 16000);

        private final String key;
        public final ChatFormatting color;
        public final int defaultCap;

        private MissileFuel(String key, ChatFormatting color, int defaultCap) {
            this.key = key;
            this.color = color;
            this.defaultCap = defaultCap;
        }

        public Component getDisplay() {
            return Component.m_237115_((String)this.key).m_130940_(this.color);
        }
    }

    public static enum MissileTier {
        TIER0("Tier 0"),
        TIER1("Tier 1"),
        TIER2("Tier 2"),
        TIER3("Tier 3"),
        TIER4("Tier 4");

        public String display;

        private MissileTier(String display) {
            this.display = display;
        }
    }
}

