/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.weapon.grenade;

import com.hbm.entity.weapon.grenade.EntityGrenadeBlackHole;
import com.hbm.entity.weapon.grenade.EntityGrenadeFire;
import com.hbm.entity.weapon.grenade.EntityGrenadeFrag;
import com.hbm.entity.weapon.grenade.EntityGrenadeGenetic;
import com.hbm.entity.weapon.grenade.EntityGrenadeStrong;
import com.hbm.entity.weapon.grenade.ThrownGrenade;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class ItemGrenade
extends Item {
    Type type;

    public ItemGrenade(Item.Properties pProperties, Type type) {
        super(pProperties.m_41487_(16));
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
        if (!pLevel.f_46443_) {
            ThrownGrenade grenade = ItemGrenade.getGrenadeEntity(this.type, pLevel, pPlayer);
            grenade.setItem(itemStack);
            grenade.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), 0.0f, 1.5f, 1.0f);
            pLevel.m_7967_((Entity)grenade);
        }
        pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!pPlayer.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)pLevel.m_5776_());
    }

    public Rarity m_41460_(ItemStack pStack) {
        return super.m_41460_(pStack);
    }

    protected static ThrownGrenade getGrenadeEntity(Type type, Level pLevel, Player pPlayer) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.GENERIC -> new EntityGrenadeGenetic((LivingEntity)pPlayer, pLevel);
            case Type.STRONG -> new EntityGrenadeStrong((LivingEntity)pPlayer, pLevel);
            case Type.FIRE -> new EntityGrenadeFire((LivingEntity)pPlayer, pLevel);
            case Type.FRAG -> new EntityGrenadeFrag((LivingEntity)pPlayer, pLevel);
            case Type.BLACK_HOLE -> new EntityGrenadeBlackHole((LivingEntity)pPlayer, pLevel);
            case Type.TAU -> null;
        };
    }

    public static enum Type {
        GENERIC,
        STRONG,
        FIRE,
        FRAG,
        BLACK_HOLE,
        TAU;

    }
}

