/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.item.zirnox;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemZirnoxRod
extends Item {
    public static final String TAG_TYPE = "zirnoxType";
    public static final String TAG_LIFE = "life";

    public ItemZirnoxRod(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public static ZirnoxRodType getRodType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_TYPE)) {
            return ZirnoxRodType.NATURAL_URANIUM_FUEL;
        }
        return ZirnoxRodType.fromIndex(tag.m_128451_(TAG_TYPE));
    }

    public static int getRodTypeIndex(ItemStack stack) {
        return ItemZirnoxRod.getRodType(stack).ordinal();
    }

    public static void setRodType(ItemStack stack, ZirnoxRodType type) {
        stack.m_41784_().m_128405_(TAG_TYPE, type.ordinal());
    }

    public static ItemStack createStack(Item item, ZirnoxRodType type) {
        ItemStack stack = new ItemStack((ItemLike)item);
        ItemZirnoxRod.setRodType(stack, type);
        return stack;
    }

    public static int getLifeTime(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_(TAG_LIFE);
    }

    public static void setLifeTime(ItemStack stack, int value) {
        stack.m_41784_().m_128405_(TAG_LIFE, value);
    }

    public static void incrementLifeTime(ItemStack stack) {
        ItemZirnoxRod.setLifeTime(stack, ItemZirnoxRod.getLifeTime(stack) + 1);
    }

    public boolean m_142522_(ItemStack stack) {
        return ItemZirnoxRod.getLifeTime(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        ZirnoxRodType type = ItemZirnoxRod.getRodType(stack);
        if (type.maxLife <= 0) {
            return 0;
        }
        float ratio = Mth.m_14036_((float)((float)ItemZirnoxRod.getLifeTime(stack) / (float)type.maxLife), (float)0.0f, (float)1.0f);
        return Math.round(13.0f - ratio * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        ZirnoxRodType type = ItemZirnoxRod.getRodType(stack);
        if (type.maxLife <= 0) {
            return 65280;
        }
        float ratio = Mth.m_14036_((float)((float)ItemZirnoxRod.getLifeTime(stack) / (float)type.maxLife), (float)0.0f, (float)1.0f);
        return Mth.m_14169_((float)Math.max(0.0f, 0.33f - ratio * 0.33f), (float)1.0f, (float)1.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        ZirnoxRodType type = ItemZirnoxRod.getRodType(stack);
        double percent = type.maxLife > 0 ? (double)ItemZirnoxRod.getLifeTime(stack) * 100.0 / (double)type.maxLife : 0.0;
        String typeName = type.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + "Type: " + String.valueOf(ChatFormatting.RESET) + typeName)));
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.YELLOW) + "Depletion: " + String.valueOf(ChatFormatting.RESET) + String.format(Locale.ROOT, "%.1f%%", percent))));
        if (type.breeding) {
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GOLD) + "Breeding rod")));
        } else {
            tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GOLD) + "Heat: " + String.valueOf(ChatFormatting.RESET) + type.heat)));
        }
        tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "Lifetime: " + String.format(Locale.ROOT, "%,d", type.maxLife))));
    }

    public static enum ZirnoxRodType {
        NATURAL_URANIUM_FUEL(250000, 30),
        URANIUM_FUEL(200000, 50),
        TH232(20000, 0, true),
        THORIUM_FUEL(200000, 40),
        MOX_FUEL(165000, 75),
        PLUTONIUM_FUEL(175000, 65),
        U233_FUEL(150000, 100),
        U235_FUEL(165000, 85),
        LES_FUEL(150000, 150),
        LITHIUM(20000, 0, true),
        ZFB_MOX(50000, 35);

        public final int maxLife;
        public final int heat;
        public final boolean breeding;

        private ZirnoxRodType(int maxLife, int heat) {
            this(maxLife, heat, false);
        }

        private ZirnoxRodType(int maxLife, int heat, boolean breeding) {
            this.maxLife = maxLife;
            this.heat = heat;
            this.breeding = breeding;
        }

        public static ZirnoxRodType fromIndex(int index) {
            ZirnoxRodType[] values = ZirnoxRodType.values();
            if (index < 0 || index >= values.length) {
                return NATURAL_URANIUM_FUEL;
            }
            return values[index];
        }
    }
}

