/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network;

import com.hbm.HBM;
import com.hbm.network.packet.toclient.AuxParticlePacket;
import com.hbm.network.packet.toclient.S2CAtomicFlashPacket;
import com.hbm.network.packet.toclient.S2CEntitySyncPacket;
import com.hbm.network.packet.toclient.S2CExplosionEffectPacket;
import com.hbm.network.packet.toclient.S2CSyncTileMessage;
import com.hbm.network.packet.toserver.C2SKeyMessage;
import com.hbm.network.packet.toserver.C2SSyncTileMessage;
import com.hbm.network.packet.toserver.S2CSyncFailMessage;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModMessages {
    public static final String version = "1.0";
    public static final SimpleChannel netHandler = NetworkRegistry.ChannelBuilder.named((ResourceLocation)HBM.rl("message")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions("1.0"::equals).serverAcceptedVersions("1.0"::equals).simpleChannel();
    private static int packetId = 0;

    public static void register() {
        ModMessages.registerServerToClient(S2CExplosionEffectPacket.class, S2CExplosionEffectPacket::decode, S2CExplosionEffectPacket::encode, S2CExplosionEffectPacket::handle);
        ModMessages.registerServerToClient(AuxParticlePacket.class, AuxParticlePacket::decode, AuxParticlePacket::encode, AuxParticlePacket::handle);
        ModMessages.registerServerToClient(S2CSyncTileMessage.class, S2CSyncTileMessage::decode, S2CSyncTileMessage::encode, S2CSyncTileMessage::handle);
        ModMessages.registerServerToClient(S2CEntitySyncPacket.class, S2CEntitySyncPacket::decode, S2CEntitySyncPacket::encode, S2CEntitySyncPacket::handle);
        ModMessages.registerServerToClient(S2CAtomicFlashPacket.class, S2CAtomicFlashPacket::decode, S2CAtomicFlashPacket::encode, S2CAtomicFlashPacket::handle);
        ModMessages.registerClientToServer(C2SSyncTileMessage.class, C2SSyncTileMessage::decode, C2SSyncTileMessage::encode, C2SSyncTileMessage::handle);
        ModMessages.registerClientToServer(S2CSyncFailMessage.class, S2CSyncFailMessage::decode, S2CSyncFailMessage::encode, S2CSyncFailMessage::handle);
        ModMessages.registerClientToServer(C2SKeyMessage.class, C2SKeyMessage::new, C2SKeyMessage::encode, C2SKeyMessage::handle);
    }

    public static <MSG> void registerClientToServer(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, FriendlyByteBuf> encoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer) {
        ModMessages.registerMessage(type, decoder, encoder, consumer, NetworkDirection.PLAY_TO_SERVER);
    }

    public static <MSG> void registerServerToClient(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, FriendlyByteBuf> encoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer) {
        ModMessages.registerMessage(type, decoder, encoder, consumer, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <MSG> void registerMessage(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, FriendlyByteBuf> encoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer, NetworkDirection direction) {
        netHandler.registerMessage(packetId++, type, encoder, decoder, consumer, Optional.of(direction));
    }

    public static <MSG> void sendToServer(MSG message) {
        netHandler.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        netHandler.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToEntity(MSG message, Entity entity) {
        netHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public static <MSG> void sendToDimension(MSG message, ResourceKey<Level> dimensionId) {
        netHandler.send(PacketDistributor.DIMENSION.with(() -> dimensionId), message);
    }

    public static <MSG> void sendToAllAround(MSG message, Entity entity, double radius) {
        ModMessages.sendToAllAround(message, new PacketDistributor.TargetPoint(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), radius, entity.m_9236_().m_46472_()));
    }

    public static <MSG> void sendToAllAround(MSG message, PacketDistributor.TargetPoint point) {
        netHandler.send(PacketDistributor.NEAR.with(() -> point), message);
    }

    public static <MSG> void sendToAll(MSG message) {
        netHandler.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <MSG> void sendToAllTracking(MSG message, BlockEntity tile) {
        ModMessages.sendToAllTracking(message, tile.m_58904_(), tile.m_58899_());
    }

    public static <MSG> void sendToAllTracking(MSG message, Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            level.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).forEach(p -> ModMessages.sendToPlayer(message, p));
        } else {
            netHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.m_6325_(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()))), message);
        }
    }
}

