/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.packet.toclient;

import com.hbm.network.IHBMMessage;
import com.hbm.particle.ModParticleTypes;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraftforge.network.NetworkEvent;

public class S2CExplosionEffectPacket
implements IHBMMessage {
    private final double x;
    private final double y;
    private final double z;
    public final int Efftype;
    public final int mode;
    public final int Effcount;

    public S2CExplosionEffectPacket(double pX, double pY, double pZ, int type, int mode, int count) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
        this.Efftype = type;
        this.mode = mode;
        this.Effcount = count;
    }

    public static S2CExplosionEffectPacket decode(FriendlyByteBuf buf) {
        return new S2CExplosionEffectPacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.Efftype);
        buf.writeInt(this.mode);
        buf.writeInt(this.Effcount);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ClientLevel pLevel = Minecraft.m_91087_().f_91073_;
            if (this.Efftype == 1 && this.mode == 1) {
                assert (pLevel != null);
                RandomSource rand = pLevel.m_213780_();
                for (int i = 0; i < this.Effcount; ++i) {
                    double motionY = rand.m_188583_() * (1.0 + (double)this.Effcount / 100.0);
                    double motionX = rand.m_188583_() * (1.0 + (double)this.Effcount / 150.0);
                    double motionZ = rand.m_188583_() * (1.0 + (double)this.Effcount / 150.0);
                    if (rand.m_188499_()) {
                        motionY = Math.abs(motionY);
                    }
                    pLevel.m_7106_((ParticleOptions)ModParticleTypes.HBM_SMOKE.get(), this.x, this.y, this.z, motionX, motionY, motionZ);
                }
            }
        });
    }
}

