/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.packet.toclient;

import com.hbm.HBM;
import com.hbm.blockentity.base2.UpdateableBlockEntity;
import com.hbm.network.IHBMMessage;
import com.hbm.network.ModMessages;
import com.hbm.network.packet.toserver.S2CSyncFailMessage;
import com.hbm.utils.WorldUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class S2CSyncTileMessage
implements IHBMMessage {
    private final CompoundTag updateTag;
    private final BlockPos pos;

    S2CSyncTileMessage(BlockPos blockPos, CompoundTag tag) {
        this.updateTag = tag;
        this.pos = blockPos;
    }

    public S2CSyncTileMessage(UpdateableBlockEntity blockEntity) {
        this(blockEntity.m_58899_(), blockEntity.getReducedUpdateTag());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (WorldUtils.isBlockLoaded((BlockGetter)world, this.pos)) {
            UpdateableBlockEntity tile = WorldUtils.getTileEntity(UpdateableBlockEntity.class, (BlockGetter)world, this.pos, true);
            if (tile == null) {
                HBM.LOGGER.warn("Update tile packet received for position: {} in world: {}, but no valid tile was found.", (Object)this.pos, (Object)world.m_46472_().m_135782_());
                ModMessages.sendToServer(new S2CSyncFailMessage(this.pos));
            } else {
                tile.handleUpdatePacket(this.updateTag);
            }
        }
        ctx.get().setPacketHandled(true);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130079_(this.updateTag);
    }

    public static S2CSyncTileMessage decode(FriendlyByteBuf buf) {
        return new S2CSyncTileMessage(buf.m_130135_(), buf.m_130260_());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof S2CSyncTileMessage)) {
            return false;
        }
        S2CSyncTileMessage msg = (S2CSyncTileMessage)obj;
        return msg.pos != null && msg.pos.equals((Object)this.pos) && msg.updateTag != null && msg.updateTag.equals((Object)this.updateTag);
    }

    public S2CSyncTileMessage copy() {
        return new S2CSyncTileMessage(new BlockPos(this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()), this.updateTag.m_6426_());
    }
}

