/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.packet.toserver;

import com.hbm.HBM;
import com.hbm.blockentity.base2.BaseMachineBlockEntity;
import com.hbm.blockentity.base2.UpdateableBlockEntity;
import com.hbm.network.IHBMMessage;
import com.hbm.utils.WorldUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;

public class C2SSyncTileMessage
implements IHBMMessage {
    private final CompoundTag updateTag;
    private final BlockPos pos;

    public C2SSyncTileMessage(BlockPos blockPos, CompoundTag tag) {
        this.updateTag = tag;
        this.pos = blockPos;
    }

    public C2SSyncTileMessage(UpdateableBlockEntity blockEntity) {
        this(blockEntity.m_58899_(), blockEntity.getClientSyncTag());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130079_(this.updateTag);
    }

    public static C2SSyncTileMessage decode(FriendlyByteBuf buf) {
        return new C2SSyncTileMessage(buf.m_130135_(), buf.m_130260_());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> this.handleServerSide(context));
        context.setPacketHandled(true);
    }

    private void handleServerSide(NetworkEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (sender == null) {
            HBM.LOGGER.warn("Received C2SSyncTileMessage without a sender; dropping update at {}", (Object)this.pos);
            return;
        }
        ServerLevel level = sender.m_284548_();
        if (!WorldUtils.isBlockLoaded((BlockGetter)level, this.pos)) {
            return;
        }
        UpdateableBlockEntity tile = WorldUtils.getTileEntity(UpdateableBlockEntity.class, (BlockGetter)level, this.pos, true);
        if (tile == null) {
            HBM.LOGGER.warn("Player {} tried to sync tile at {} but none was found", (Object)sender.m_36316_().getName(), (Object)this.pos);
            return;
        }
        if (!this.isSenderAuthorized(sender, tile)) {
            HBM.LOGGER.warn("Blocked unauthorized sync attempt by {} for tile {}", (Object)sender.m_36316_().getName(), (Object)this.pos);
            return;
        }
        tile.handleClientPacket(this.updateTag);
    }

    private boolean isSenderAuthorized(ServerPlayer sender, UpdateableBlockEntity tile) {
        double maxDistanceSq = 256.0;
        if (sender.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) > 256.0) {
            return false;
        }
        if (tile instanceof BaseMachineBlockEntity) {
            BaseMachineBlockEntity machine = (BaseMachineBlockEntity)tile;
            return machine.canOpen((Player)sender);
        }
        return true;
    }
}

