/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.datagen.HBMJsonProvider;
import com.hbm.particle.type.DeadLeafParticle;
import com.hbm.particle.type.HBMSmokeParticle;
import com.hbm.particle.type.ParticleRocketFlame;
import com.hbm.particle.type.ShockWaveParticle;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ModParticleTypes {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"hbm");
    public static final Map<RegistryObject<SimpleParticleType>, ParticleEngine.SpriteParticleRegistration<SimpleParticleType>> simpleParticles = new HashMap<RegistryObject<SimpleParticleType>, ParticleEngine.SpriteParticleRegistration<SimpleParticleType>>();
    public static final RegistryObject<SimpleParticleType> HBM_SMOKE = PARTICLE_TYPES.register("nuke_smoke", () -> new SimpleParticleType(false));
    public static final RegistryObject<SimpleParticleType> ROCKET_FLAME = PARTICLE_TYPES.register("missile_contrail", () -> new SimpleParticleType(false));
    public static final RegistryObject<SimpleParticleType> RADIATION_FOG = PARTICLE_TYPES.register("fog", () -> new SimpleParticleType(false));
    public static final RegistryObject<SimpleParticleType> SHOCKWAVE = ModParticleTypes.addSimple("shockwave", ShockWaveParticle::new);
    public static final RegistryObject<SimpleParticleType> DEAD_LEAF = ModParticleTypes.addSimple("dead_leaf", DeadLeafParticle::new);
    public static final RegistryObject<SimpleParticleType> LAUNCH_SMOKE = ModParticleTypes.addSimple("launch_smoke", DeadLeafParticle::new);

    public static RegistryObject<SimpleParticleType> addSimple(String name, final SimpleParticleConstructor<? extends Particle> constructor) {
        RegistryObject object = PARTICLE_TYPES.register(name, () -> new SimpleParticleType(false));
        simpleParticles.put((RegistryObject<SimpleParticleType>)object, (ParticleEngine.SpriteParticleRegistration<SimpleParticleType>)((ParticleEngine.SpriteParticleRegistration)spriteSet -> new ParticleProvider<SimpleParticleType>(){

            @Nullable
            public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
                return constructor.create(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, spriteSet);
            }
        }));
        return object;
    }

    public static void register(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)HBM_SMOKE.get(), HBMSmokeParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ROCKET_FLAME.get(), ParticleRocketFlame.Provider::new);
        simpleParticles.forEach((registry, provider) -> event.registerSpriteSet((ParticleType)registry.get(), provider));
    }

    public static void generateJson(HBMJsonProvider provider) {
        simpleParticles.forEach((k, v) -> provider.simpleParticle(k.getId().m_135815_()));
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface SimpleParticleConstructor<T extends Particle> {
        public T create(ClientLevel var1, double var2, double var4, double var6, double var8, double var10, double var12, SpriteSet var14);
    }
}

