/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.procedures;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hbm.compat.bigexplosives.BigExplosivesMod;
import com.hbm.init.BigExplosivesModEntities;
import com.hbm.init.BigExplosivesModSounds;
import com.hbm.network.ModMessages;
import com.hbm.network.packet.toclient.S2CAtomicFlashPacket;
import com.hbm.render.entity.AtomicBombExplosionEntity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLPaths;

public final class AtomicExplosionHelper {
    private static final double DEFAULT_DAMAGE = 2000.0;
    private static final double EFFECT_RADIUS = 140.0;

    private AtomicExplosionHelper() {
    }

    static void detonate(LevelAccessor world, double x, double y, double z, Entity source) {
        Level level;
        block3: {
            block2: {
                if (!(world instanceof Level)) break block2;
                level = (Level)world;
                if (!level.f_46443_) break block3;
            }
            return;
        }
        double baseDamage = AtomicExplosionHelper.readConfiguredDamage();
        Vec3 center = new Vec3(x, y, z);
        level.m_254849_(source, x, y, z, 60.0f, Level.ExplosionInteraction.TNT);
        AtomicExplosionHelper.triggerEffects(level, center, baseDamage);
    }

    public static void triggerEffects(Level level, Vec3 center) {
        if (level == null || level.f_46443_) {
            return;
        }
        double baseDamage = AtomicExplosionHelper.readConfiguredDamage();
        AtomicExplosionHelper.triggerEffects(level, center, baseDamage);
    }

    private static void triggerEffects(Level level, Vec3 center, double baseDamage) {
        if (level == null || level.f_46443_) {
            return;
        }
        AtomicExplosionHelper.playBlastSounds(level, center);
        AtomicExplosionHelper.spawnExplosionEntity(level, center);
        AtomicExplosionHelper.applyEffects(level, center, baseDamage);
    }

    private static void playBlastSounds(Level level, Vec3 center) {
        level.m_5594_(null, BlockPos.m_274446_((Position)center), (SoundEvent)BigExplosivesModSounds.BOOM.get(), SoundSource.NEUTRAL, 80.0f, 1.0f);
        level.m_5594_(null, BlockPos.m_274446_((Position)center), (SoundEvent)BigExplosivesModSounds.ATOM_BOMB_CLOSE.get(), SoundSource.NEUTRAL, 200.0f, 1.0f);
        BigExplosivesMod.queueServerWork(2, () -> level.m_5594_(null, BlockPos.m_274446_((Position)center), (SoundEvent)BigExplosivesModSounds.ATOM_BOMB_FAR.get(), SoundSource.NEUTRAL, 400.0f, 1.0f));
        BigExplosivesMod.queueServerWork(4, () -> level.m_5594_(null, BlockPos.m_274446_((Position)center), (SoundEvent)BigExplosivesModSounds.ATOM_BOMB_EXTREMELY_FAR.get(), SoundSource.NEUTRAL, 600.0f, 1.0f));
        BigExplosivesMod.queueServerWork(6, () -> level.m_5594_(null, BlockPos.m_274446_((Position)center), (SoundEvent)BigExplosivesModSounds.SUPER_FAR_EXPLOSION.get(), SoundSource.NEUTRAL, 1000.0f, 1.0f));
    }

    private static void spawnExplosionEntity(Level level, Vec3 center) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AtomicBombExplosionEntity explosion = (AtomicBombExplosionEntity)((EntityType)BigExplosivesModEntities.ATOMIC_BOMB_EXPLOSION.get()).m_20615_((Level)serverLevel);
        if (explosion != null) {
            explosion.m_7678_(center.f_82479_, center.f_82480_ - 3.0, center.f_82481_, 0.0f, 0.0f);
            serverLevel.m_7967_((Entity)explosion);
        }
    }

    private static void applyEffects(Level level, Vec3 center, double baseDamage) {
        AABB area = new AABB(center, center).m_82400_(140.0);
        List targets = level.m_6443_(LivingEntity.class, area, LivingEntity::m_6084_);
        for (LivingEntity target : targets) {
            double distance = Math.sqrt(target.m_20238_(center));
            double factor = Math.max(0.0, 1.0 - distance / 140.0);
            if (factor <= 0.0) continue;
            float damage = (float)(baseDamage * factor * factor);
            if (damage > 0.0f) {
                DamageSource source = new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268565_));
                target.m_6469_(source, damage);
            }
            int nauseaDuration = (int)Mth.m_14008_((double)(60.0 + 140.0 * factor), (double)40.0, (double)200.0);
            int witherDuration = (int)(6000.0 * factor);
            if (nauseaDuration > 0) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, nauseaDuration, 0, false, false));
            }
            if (witherDuration > 0) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, Math.max(200, witherDuration), 0, false, true));
            }
            if (!(target instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)target;
            float alpha = Mth.m_14036_((float)(0.35f + 0.65f * (float)factor), (float)0.2f, (float)1.0f);
            int flashDuration = (int)Mth.m_14008_((double)(60.0 + 200.0 * factor), (double)60.0, (double)260.0);
            ModMessages.sendToPlayer(new S2CAtomicFlashPacket(alpha, flashDuration), serverPlayer);
        }
    }

    /*
     * Loose catch block
     */
    private static double readConfiguredDamage() {
        block12: {
            BufferedReader reader;
            block10: {
                double d;
                block11: {
                    Path configPath = FMLPaths.CONFIGDIR.get().resolve("bigexplosivesconfig.json");
                    if (!Files.exists(configPath, new LinkOption[0])) {
                        return 2000.0;
                    }
                    reader = Files.newBufferedReader(configPath);
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    if (!json.has("AtomicBombDamage")) break block10;
                    d = json.get("AtomicBombDamage").getAsDouble();
                    if (reader == null) break block11;
                    ((Reader)reader).close();
                }
                return d;
            }
            try {
                if (reader != null) {
                    ((Reader)reader).close();
                }
                break block12;
                {
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            catch (IOException | IllegalStateException ex) {
                BigExplosivesMod.LOGGER.warn("Failed to read bigexplosivesconfig.json", (Throwable)ex);
            }
        }
        return 2000.0;
    }
}

