/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.procedures;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public final class FiveHundredKgBombEntityDiesProcedure {
    private static final Gson GSON = new Gson();
    private static final String CONFIG_FILE = "bigexplosivesconfig.json";
    private static final double DEFAULT_CLUSTER_RADIUS = 6.0;
    private static final int DEFAULT_CLUSTER_COUNT = 8;
    private static final float DEFAULT_BLAST_POWER = 12.0f;

    private FiveHundredKgBombEntityDiesProcedure() {
    }

    public static void execute(LevelAccessor world, double x, double y, double z) {
        JsonObject config = FiveHundredKgBombEntityDiesProcedure.readConfig();
        double spawnRadius = FiveHundredKgBombEntityDiesProcedure.sanitized(config, "WidthOfThe500kgExplosionSpawnRadius", 6.0);
        int explosionCount = FiveHundredKgBombEntityDiesProcedure.sanitizedInt(config, "AmountOfExplosions500kgSpawns", 8);
        float blastPower = (float)FiveHundredKgBombEntityDiesProcedure.sanitized(config, "FiveHundredKgExplosionPower", 12.0);
        if (world instanceof Level) {
            Level level = (Level)world;
            FiveHundredKgBombEntityDiesProcedure.playBlastSound(level, x, y, z);
            if (!level.m_5776_()) {
                FiveHundredKgBombEntityDiesProcedure.spawnCentralExplosion(level, x, y, z, blastPower);
                FiveHundredKgBombEntityDiesProcedure.spawnRandomExplosions(level, x, y, z, spawnRadius, explosionCount);
            }
        }
    }

    private static double sanitized(JsonObject config, String key, double fallback) {
        if (config.has(key)) {
            try {
                double value = config.get(key).getAsDouble();
                return value > 0.0 ? value : fallback;
            }
            catch (ClassCastException | IllegalStateException ex) {
                return fallback;
            }
        }
        return fallback;
    }

    private static int sanitizedInt(JsonObject config, String key, int fallback) {
        if (config.has(key)) {
            try {
                int value = config.get(key).getAsInt();
                return value > 0 ? value : fallback;
            }
            catch (ClassCastException | IllegalStateException ex) {
                return fallback;
            }
        }
        return fallback;
    }

    private static void playBlastSound(Level level, double x, double y, double z) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("big_explosives:big_bomb"));
        if (sound == null) {
            return;
        }
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (!level.m_5776_()) {
            level.m_5594_(null, pos, sound, SoundSource.MASTER, 200.0f, 1.0f);
        } else {
            level.m_7785_(x, y, z, sound, SoundSource.MASTER, 200.0f, 1.0f, false);
        }
    }

    private static void spawnRandomExplosions(Level level, double x, double y, double z, double radius, int count) {
        RandomSource random = RandomSource.m_216327_();
        int cappedCount = Math.max(0, Math.min(32, count));
        for (int i = 0; i < cappedCount; ++i) {
            double offsetX = radius <= 0.0 ? 0.0 : Mth.m_216263_((RandomSource)random, (double)(-radius), (double)radius);
            double offsetZ = radius <= 0.0 ? 0.0 : Mth.m_216263_((RandomSource)random, (double)(-radius), (double)radius);
            double offsetY = Mth.m_216263_((RandomSource)random, (double)-7.0, (double)5.0);
            level.m_254849_(null, x + offsetX, y + offsetY, z + offsetZ, 6.0f, Level.ExplosionInteraction.TNT);
        }
    }

    private static void spawnCentralExplosion(Level level, double x, double y, double z, float power) {
        float radius = Math.max(8.0f, Math.min(20.0f, power));
        level.m_254849_(null, x, y, z, radius, Level.ExplosionInteraction.TNT);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x, y + 1.0, z, 2, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y + 0.5, z, 20, 0.6, 0.4, 0.6, 0.02);
        }
    }

    private static JsonObject readConfig() {
        Path configDir = FMLPaths.GAMEDIR.get().resolve("config");
        Path configPath = configDir.resolve(CONFIG_FILE);
        if (!Files.isRegularFile(configPath, new LinkOption[0])) {
            return new JsonObject();
        }
        try {
            String raw = Files.readString(configPath);
            return (JsonObject)GSON.fromJson(raw, JsonObject.class);
        }
        catch (JsonSyntaxException | IOException ex) {
            return new JsonObject();
        }
    }
}

