/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.reactor.pile;

import com.hbm.reactor.pile.NeutronNode;
import com.hbm.reactor.pile.NeutronStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public final class NeutronNodeWorld {
    private static final Map<Level, StreamWorld> STREAM_WORLDS = new IdentityHashMap<Level, StreamWorld>();

    private NeutronNodeWorld() {
    }

    public static StreamWorld getOrCreate(Level level) {
        return STREAM_WORLDS.computeIfAbsent(level, ignored -> new StreamWorld());
    }

    public static void remove(Level level) {
        STREAM_WORLDS.remove(level);
    }

    public static void clear() {
        STREAM_WORLDS.clear();
    }

    public static Collection<Map.Entry<Level, StreamWorld>> worlds() {
        return Collections.unmodifiableCollection(STREAM_WORLDS.entrySet());
    }

    public static final class StreamWorld {
        private final List<NeutronStream> streams = new ArrayList<NeutronStream>();
        private final Map<BlockPos, NeutronNode> nodeCache = new HashMap<BlockPos, NeutronNode>();

        public void queue(NeutronStream stream) {
            this.streams.add(stream);
        }

        public void runStreams(Level level) {
            if (this.streams.isEmpty()) {
                return;
            }
            for (NeutronStream stream : this.streams) {
                stream.run(level, this);
            }
            this.streams.clear();
        }

        public NeutronNode getNode(BlockPos pos) {
            return this.nodeCache.get(pos);
        }

        public void addNode(NeutronNode node) {
            this.nodeCache.put(node.pos(), node);
        }

        public void removeNode(BlockPos pos) {
            this.nodeCache.remove(pos);
        }

        public void removeDeadNodes() {
            this.nodeCache.entrySet().removeIf(entry -> ((NeutronNode)entry.getValue()).blockEntity().m_58901_());
        }
    }
}

