/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.reactor.pile;

import com.hbm.api.block.IPileNeutronReceiver;
import com.hbm.block.machine.pile.ChicagoGraphiteDetectorBlock;
import com.hbm.block.machine.pile.ChicagoGraphiteRodBlock;
import com.hbm.blockentity.machine.pile.ChicagoPileBlockEntity;
import com.hbm.reactor.pile.NeutronNode;
import com.hbm.reactor.pile.NeutronNodeWorld;
import com.hbm.reactor.pile.NeutronStream;
import com.hbm.utils.ContaminationUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class PileNeutronHandler {
    private static final int RANGE = 5;

    private PileNeutronHandler() {
    }

    public static PileNeutronNode makeNode(NeutronNodeWorld.StreamWorld world, ChicagoPileBlockEntity tile) {
        NeutronNode node = world.getNode(tile.m_58899_());
        if (node instanceof PileNeutronNode) {
            PileNeutronNode pileNode = (PileNeutronNode)node;
            return pileNode;
        }
        PileNeutronNode created = new PileNeutronNode(tile);
        world.addNode(created);
        return created;
    }

    public static final class PileNeutronNode
    extends NeutronNode {
        public PileNeutronNode(ChicagoPileBlockEntity tile) {
            super(tile);
        }

        public ChicagoPileBlockEntity pile() {
            return (ChicagoPileBlockEntity)this.blockEntity();
        }
    }

    public static final class PileNeutronStream
    extends NeutronStream {
        public PileNeutronStream(NeutronNode origin, Vec3 direction, double fluxQuantity) {
            super(origin, direction.m_82541_(), fluxQuantity);
        }

        @Override
        public void run(Level level, NeutronNodeWorld.StreamWorld streamWorld) {
            if (this.isDead()) {
                return;
            }
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            BlockPos start = this.originPos();
            for (double i = 0.5; i <= 5.0; i += 0.5) {
                int x = Mth.m_14107_((double)((double)start.m_123341_() + 0.5 + this.direction.f_82479_ * i));
                int y = Mth.m_14107_((double)((double)start.m_123342_() + 0.5 + this.direction.f_82480_ * i));
                int z = Mth.m_14107_((double)((double)start.m_123343_() + 0.5 + this.direction.f_82481_ * i));
                cursor.m_122178_(x, y, z);
                if (cursor.equals((Object)start)) continue;
                BlockState state = level.m_8055_((BlockPos)cursor);
                BlockEntity tile = level.m_7702_((BlockPos)cursor);
                if (tile instanceof ChicagoPileBlockEntity) {
                    ChicagoPileBlockEntity pileTile = (ChicagoPileBlockEntity)tile;
                    streamWorld.addNode(new PileNeutronNode(pileTile));
                }
                if (tile instanceof IPileNeutronReceiver) {
                    IPileNeutronReceiver receiver = (IPileNeutronReceiver)tile;
                    receiver.receiveNeutrons((int)Math.floor(this.fluxQuantity));
                    if (!PileNeutronStream.allowsThrough(state)) {
                        return;
                    }
                } else if (PileNeutronStream.blocksFlux(state)) {
                    return;
                }
                this.contaminateEntities(level, (BlockPos)cursor);
            }
        }

        private static boolean blocksFlux(BlockState state) {
            Block block = state.m_60734_();
            if (block instanceof ChicagoGraphiteRodBlock) {
                ChicagoGraphiteRodBlock rodBlock = (ChicagoGraphiteRodBlock)block;
                return rodBlock.isInserted(state);
            }
            return false;
        }

        private static boolean allowsThrough(BlockState state) {
            ChicagoGraphiteDetectorBlock detector;
            Block block = state.m_60734_();
            return block instanceof ChicagoGraphiteDetectorBlock && (detector = (ChicagoGraphiteDetectorBlock)block).isPowered(state);
        }

        private void contaminateEntities(Level level, BlockPos pos) {
            if (this.fluxQuantity <= 0.0) {
                return;
            }
            AABB box = new AABB(pos).m_82400_(0.5);
            List entities = level.m_45976_(LivingEntity.class, box);
            if (entities.isEmpty()) {
                return;
            }
            float dose = (float)(this.fluxQuantity / 4.0);
            for (LivingEntity entity : entities) {
                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, dose);
            }
        }
    }
}

