/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.reactor.pile;

import com.hbm.reactor.pile.NeutronNodeWorld;
import java.util.Map;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class PileNeutronTicker {
    private static boolean registered;

    private PileNeutronTicker() {
    }

    public static void init() {
        if (registered) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        registered = true;
    }

    private static final class Events {
        private int cacheTicker;

        private Events() {
        }

        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            boolean cleanup;
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            boolean bl = cleanup = ++this.cacheTicker >= 20;
            if (cleanup) {
                this.cacheTicker = 0;
            }
            for (Map.Entry<Level, NeutronNodeWorld.StreamWorld> entry : NeutronNodeWorld.worlds()) {
                entry.getValue().runStreams(entry.getKey());
                if (!cleanup) continue;
                entry.getValue().removeDeadNodes();
            }
        }

        @SubscribeEvent
        public void onLevelUnload(LevelEvent.Unload event) {
            if (!event.getLevel().m_5776_()) {
                NeutronNodeWorld.remove((Level)event.getLevel());
            }
        }
    }
}

