/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.reactor.pwr;

import java.util.Locale;
import net.minecraft.ChatFormatting;

public enum PWRFuelType {
    MEU(5.0, new LogFunction(600.0).withDiv(2500.0), 1.0E9),
    HEU233(7.5, new SqrtFunction(25.0), 1.0E9),
    HEU235(7.5, new SqrtFunction(22.5), 1.0E9),
    MEN(7.5, new LogFunction(675.0).withDiv(2500.0), 1.0E9),
    HEN237(7.5, new SqrtFunction(27.5), 1.0E9),
    MOX(7.5, new LogFunction(600.0).withDiv(2500.0), 1.0E9),
    MEP(7.5, new LogFunction(675.0).withDiv(2500.0), 1.0E9),
    HEP239(10.0, new SqrtFunction(22.5), 1.0E9),
    HEP241(10.0, new SqrtFunction(25.0), 1.0E9),
    MEA(7.5, new LogFunction(750.0).withDiv(2500.0), 1.0E9),
    HEA242(10.0, new SqrtFunction(25.0), 1.0E9),
    HES326(12.5, new SqrtFunction(27.5), 1.0E9),
    HES327(12.5, new SqrtFunction(30.0), 1.0E9),
    BFB_AM_MIX(2.5, new SqrtFunction(15.0), 2.5E8),
    BFB_PU241(2.5, new SqrtFunction(15.0), 2.5E8);

    public final double heatEmission;
    public final FuelFunction function;
    public final double yield;

    private PWRFuelType(double heatEmission, FuelFunction function, double yield) {
        this.heatEmission = heatEmission;
        this.function = function;
        this.yield = yield;
    }

    public double outputForFlux(double fluxPerRod) {
        return this.function.effonix(fluxPerRod);
    }

    public String getFunctionLabel() {
        return this.function.getLabel();
    }

    public String getDangerLabel() {
        return this.function.getDanger();
    }

    public static PWRFuelType fromIndex(int index) {
        PWRFuelType[] values = PWRFuelType.values();
        if (index < 0 || index >= values.length) {
            return MEU;
        }
        return values[index];
    }

    public static interface FuelFunction {
        public double effonix(double var1);

        public String getLabel();

        public String getDanger();
    }

    private static final class LogFunction
    extends BaseFunction {
        private final double level;

        private LogFunction(double level) {
            this.level = level;
            this.withOff(1.0);
        }

        @Override
        public double effonix(double x) {
            return Math.log10(this.getX(x)) * this.level;
        }

        @Override
        public String getLabel() {
            return "log10(" + this.getXName(false) + ") * " + String.format(Locale.ROOT, "%,.1f", this.level);
        }

        @Override
        public String getDanger() {
            return String.valueOf(ChatFormatting.YELLOW) + "MEDIUM / LOGARITHMIC";
        }
    }

    private static abstract class BaseFunction
    implements FuelFunction {
        protected double div = 1.0;
        protected double off = 0.0;

        private BaseFunction() {
        }

        public BaseFunction withDiv(double div) {
            this.div = div;
            return this;
        }

        public BaseFunction withOff(double off) {
            this.off = off;
            return this;
        }

        protected double getX(double x) {
            return x / this.div + this.off;
        }

        protected String getXName() {
            return this.getXName(true);
        }

        protected String getXName(boolean brackets) {
            Object x = "x";
            boolean modified = false;
            if (this.div != 1.0) {
                x = (String)x + " / " + String.format(Locale.ROOT, "%,.1f", this.div);
                modified = true;
            }
            if (this.off != 0.0) {
                x = (String)x + " + " + String.format(Locale.ROOT, "%,.1f", this.off);
                modified = true;
            }
            if (modified && brackets) {
                x = "(" + (String)x + ")";
            }
            return x;
        }
    }

    private static final class SqrtFunction
    extends BaseFunction {
        private final double level;

        private SqrtFunction(double level) {
            this.level = level;
        }

        @Override
        public double effonix(double x) {
            return Math.sqrt(this.getX(x)) * this.level;
        }

        @Override
        public String getLabel() {
            return "sqrt(" + this.getXName(false) + ") * " + String.format(Locale.ROOT, "%,.3f", this.level);
        }

        @Override
        public String getDanger() {
            return String.valueOf(ChatFormatting.YELLOW) + "MEDIUM / SQUARE ROOT";
        }
    }
}

