/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.reactor.rbmk;

import com.hbm.reactor.rbmk.RBMKLidType;
import com.hbm.reactor.rbmk.RBMKSettings;
import java.util.Objects;
import net.minecraft.core.BlockPos;

public final class RBMKColumnState {
    private final BlockPos corePosition;
    private final RBMKSettings settings;
    private RBMKLidType lidType;
    private double controlRodInsertion;
    private double heat;
    private boolean meltedDown;

    RBMKColumnState(BlockPos corePosition, RBMKSettings settings, RBMKLidType lidType) {
        this.corePosition = Objects.requireNonNull(corePosition, "corePosition");
        this.settings = Objects.requireNonNull(settings, "settings");
        this.lidType = lidType;
    }

    public BlockPos corePosition() {
        return this.corePosition;
    }

    public int columnHeight() {
        return this.settings.columnHeight();
    }

    public RBMKSettings settings() {
        return this.settings;
    }

    public RBMKLidType lidType() {
        return this.lidType;
    }

    public void setLidType(RBMKLidType lidType) {
        this.lidType = lidType;
    }

    public double controlRodInsertion() {
        return this.controlRodInsertion;
    }

    public void setControlRodInsertion(double controlRodInsertion) {
        this.controlRodInsertion = controlRodInsertion < 0.0 ? 0.0 : (controlRodInsertion > 1.0 ? 1.0 : controlRodInsertion);
    }

    public double heat() {
        return this.heat;
    }

    public void addHeat(double delta) {
        this.heat = Math.max(0.0, this.heat + delta);
    }

    public boolean meltedDown() {
        return this.meltedDown;
    }

    public void markMeltedDown() {
        this.meltedDown = true;
    }

    public String toString() {
        return "RBMKColumnState{corePosition=" + String.valueOf(this.corePosition) + ", settings=" + String.valueOf(this.settings) + ", lidType=" + String.valueOf((Object)this.lidType) + ", controlRodInsertion=" + this.controlRodInsertion + ", heat=" + this.heat + ", meltedDown=" + this.meltedDown + "}";
    }
}

