/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.reactor.rbmk;

import com.hbm.reactor.rbmk.RBMKColumnState;
import com.hbm.reactor.rbmk.RBMKLidType;
import com.hbm.reactor.rbmk.RBMKSettings;
import com.hbm.registries.ModSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public final class RBMKLevelContext {
    private static final double TIME_STEP = 0.05;
    private static final Direction[] TRANSFER_DIRECTIONS = new Direction[]{Direction.EAST, Direction.SOUTH};
    private final ServerLevel level;
    private final Map<BlockPos, RBMKColumnState> columns = new HashMap<BlockPos, RBMKColumnState>();
    private double cachedControlRodInsertion;

    RBMKLevelContext(ServerLevel level) {
        this.level = level;
    }

    public ServerLevel level() {
        return this.level;
    }

    public Map<BlockPos, RBMKColumnState> snapshot() {
        return Collections.unmodifiableMap(this.columns);
    }

    public double controlRodAverage() {
        return this.cachedControlRodInsertion;
    }

    public RBMKColumnState registerColumn(BlockPos corePos, RBMKSettings settings) {
        BlockPos key = corePos.m_7949_();
        RBMKColumnState state = new RBMKColumnState(key, settings, RBMKLidType.NONE);
        this.columns.put(key, state);
        return state;
    }

    public void removeColumn(BlockPos corePos) {
        this.columns.remove(corePos);
    }

    public Optional<RBMKColumnState> column(BlockPos corePos) {
        return Optional.ofNullable(this.columns.get(corePos));
    }

    public boolean addHeat(BlockPos corePos, double heat) {
        RBMKColumnState state = this.columns.get(corePos);
        if (state == null) {
            return false;
        }
        state.addHeat(heat);
        return true;
    }

    public boolean setLidState(BlockPos corePos, RBMKLidType lidType) {
        RBMKColumnState state = this.columns.get(corePos);
        if (state == null) {
            return false;
        }
        state.setLidType(lidType);
        return true;
    }

    public boolean setControlRodInsertion(BlockPos corePos, double insertion) {
        RBMKColumnState state = this.columns.get(corePos);
        if (state == null) {
            return false;
        }
        state.setControlRodInsertion(insertion);
        return true;
    }

    public void tick() {
        RBMKColumnState state;
        if (this.columns.isEmpty()) {
            this.cachedControlRodInsertion = 0.0;
            return;
        }
        double controlSum = 0.0;
        for (RBMKColumnState state2 : this.columns.values()) {
            controlSum += state2.controlRodInsertion();
        }
        this.cachedControlRodInsertion = controlSum / (double)this.columns.size();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(this.columns.keySet());
        HashMap<BlockPos, Double> transferDeltas = new HashMap<BlockPos, Double>();
        for (BlockPos blockPos : positions) {
            state = this.columns.get(blockPos);
            if (state == null) continue;
            double heat = state.heat();
            for (Direction direction : TRANSFER_DIRECTIONS) {
                double diff;
                double transfer;
                double flow;
                BlockPos neighborPos = blockPos.m_121945_(direction);
                RBMKColumnState neighbor = this.columns.get(neighborPos);
                if (neighbor == null || (flow = Math.min(state.settings().columnHeatFlow(), neighbor.settings().columnHeatFlow())) <= 0.0 || (transfer = (diff = heat - neighbor.heat()) * 0.5 * flow * 0.05) == 0.0) continue;
                transferDeltas.merge(blockPos, -transfer, Double::sum);
                transferDeltas.merge(neighborPos, transfer, Double::sum);
            }
        }
        for (Map.Entry entry : transferDeltas.entrySet()) {
            state = this.columns.get(entry.getKey());
            if (state == null) continue;
            state.addHeat((Double)entry.getValue());
        }
        for (BlockPos blockPos : positions) {
            double passiveCooling;
            state = this.columns.get(blockPos);
            if (state == null || (passiveCooling = state.settings().passiveCooling()) <= 0.0) continue;
            state.addHeat(-passiveCooling * 0.05);
        }
        this.handleMeltdowns(positions);
    }

    private void handleMeltdowns(List<BlockPos> positions) {
        for (BlockPos pos : positions) {
            double threshold;
            RBMKColumnState state = this.columns.get(pos);
            if (state == null || state.meltedDown() || (threshold = state.settings().meltdownHeat()) <= 0.0 || state.heat() < threshold) continue;
            state.markMeltedDown();
            this.triggerMeltdown(pos, state);
        }
    }

    private void triggerMeltdown(BlockPos corePos, RBMKColumnState state) {
        double strength = Math.max(0.0, state.settings().meltdownExplosionStrength());
        this.level.m_254849_(null, (double)corePos.m_123341_() + 0.5, (double)corePos.m_123342_() + 0.5, (double)corePos.m_123343_() + 0.5, (float)strength, Level.ExplosionInteraction.BLOCK);
        this.level.m_5594_(null, corePos, (SoundEvent)ModSounds.BLOCK_RBMK_EXPLOSION.get(), SoundSource.BLOCKS, 6.0f, 1.0f);
        int height = Math.max(1, state.columnHeight());
        for (int y = 0; y < height; ++y) {
            BlockPos pos = corePos.m_6630_(y);
            BlockState blockState = this.level.m_8055_(pos);
            if (blockState.m_60795_()) continue;
            this.level.m_46961_(pos, false);
        }
        this.level.m_7731_(corePos, Blocks.f_49991_.m_49966_(), 3);
        BlockPos above = corePos.m_7494_();
        if (this.level.m_8055_(above).m_60795_()) {
            this.level.m_7731_(above, Blocks.f_49991_.m_49966_(), 3);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos firePos = corePos.m_121945_(direction);
            if (!this.level.m_8055_(firePos).m_60795_() || !this.level.m_8055_(firePos.m_7495_()).m_60804_((BlockGetter)this.level, firePos.m_7495_())) continue;
            this.level.m_7731_(firePos, Blocks.f_50083_.m_49966_(), 3);
        }
        this.columns.remove(corePos);
    }
}

