/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.reactor.rbmk;

import com.hbm.reactor.rbmk.RBMKLevelContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class RBMKManager {
    private static final Map<ResourceKey<Level>, RBMKLevelContext> CONTEXTS = new ConcurrentHashMap<ResourceKey<Level>, RBMKLevelContext>();
    private static boolean registered;

    private RBMKManager() {
    }

    public static void init() {
        if (registered) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new Events());
        registered = true;
    }

    public static RBMKLevelContext context(ServerLevel level) {
        return CONTEXTS.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new RBMKLevelContext(level));
    }

    public static void remove(ServerLevel level) {
        CONTEXTS.remove(level.m_46472_());
    }

    public static void clear() {
        CONTEXTS.clear();
    }

    private static final class Events {
        private Events() {
        }

        @SubscribeEvent
        public void onLevelUnload(LevelEvent.Unload event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                RBMKManager.remove(serverLevel);
            }
        }

        @SubscribeEvent
        public void onServerStopped(ServerStoppedEvent event) {
            RBMKManager.clear();
        }

        @SubscribeEvent
        public void onLevelTick(TickEvent.LevelTickEvent event) {
            ServerLevel serverLevel;
            RBMKLevelContext context;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Level level = event.level;
            if (level instanceof ServerLevel && (context = CONTEXTS.get((serverLevel = (ServerLevel)level).m_46472_())) != null) {
                context.tick();
            }
        }
    }
}

