/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.reactor.rbmk;

import com.hbm.config.ConfigRBMK;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;

public final class RBMKSettings {
    public static final RBMKSettings DEFAULT = RBMKSettings.builder().build();
    private final int columnHeight;
    private final double passiveCooling;
    private final double columnHeatFlow;
    private final double reactivityModifier;
    private final double meltdownHeat;
    private final double meltdownExplosionStrength;

    private RBMKSettings(Builder builder) {
        this.columnHeight = builder.columnHeight;
        this.passiveCooling = builder.passiveCooling;
        this.columnHeatFlow = builder.columnHeatFlow;
        this.reactivityModifier = builder.reactivityModifier;
        this.meltdownHeat = builder.meltdownHeat;
        this.meltdownExplosionStrength = builder.meltdownExplosionStrength;
    }

    public int columnHeight() {
        return this.columnHeight;
    }

    public double passiveCooling() {
        return this.passiveCooling;
    }

    public double columnHeatFlow() {
        return this.columnHeatFlow;
    }

    public double reactivityModifier() {
        return this.reactivityModifier;
    }

    public double meltdownHeat() {
        return this.meltdownHeat;
    }

    public double meltdownExplosionStrength() {
        return this.meltdownExplosionStrength;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return RBMKSettings.builder().columnHeight(this.columnHeight).passiveCooling(this.passiveCooling).columnHeatFlow(this.columnHeatFlow).reactivityModifier(this.reactivityModifier).meltdownHeat(this.meltdownHeat).meltdownExplosionStrength(this.meltdownExplosionStrength);
    }

    public static RBMKSettings forLevel(ServerLevel level) {
        Objects.requireNonNull(level, "level");
        return RBMKSettings.builder().columnHeight(ConfigRBMK.columnHeight).passiveCooling(ConfigRBMK.passiveCooling).columnHeatFlow(ConfigRBMK.columnHeatFlow).reactivityModifier(ConfigRBMK.reactivityModifier).meltdownHeat(ConfigRBMK.meltdownHeat).meltdownExplosionStrength(ConfigRBMK.meltdownExplosionStrength).build();
    }

    public static final class Builder {
        private int columnHeight = 4;
        private double passiveCooling = 1.0;
        private double columnHeatFlow = 0.2;
        private double reactivityModifier = 1.0;
        private double meltdownHeat = 10000.0;
        private double meltdownExplosionStrength = 6.0;

        private Builder() {
        }

        public Builder columnHeight(int columnHeight) {
            this.columnHeight = Math.max(2, columnHeight);
            return this;
        }

        public Builder passiveCooling(double passiveCooling) {
            this.passiveCooling = Math.max(0.0, passiveCooling);
            return this;
        }

        public Builder columnHeatFlow(double columnHeatFlow) {
            this.columnHeatFlow = Math.max(0.0, Math.min(1.0, columnHeatFlow));
            return this;
        }

        public Builder reactivityModifier(double reactivityModifier) {
            this.reactivityModifier = Math.max(0.0, reactivityModifier);
            return this;
        }

        public Builder meltdownHeat(double meltdownHeat) {
            this.meltdownHeat = Math.max(0.0, meltdownHeat);
            return this;
        }

        public Builder meltdownExplosionStrength(double meltdownExplosionStrength) {
            this.meltdownExplosionStrength = Math.max(0.0, meltdownExplosionStrength);
            return this;
        }

        public RBMKSettings build() {
            return new RBMKSettings(this);
        }
    }
}

