/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.registries;

import com.hbm.HBM;
import com.hbm.api.resource.OreType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;

public class ModTags {

    public static class Items {
        public static final TagKey<Item> RAW_MATERIAL = Items.forgeTag("raw_materials");
        public static final Map<String, TagKey<Item>> NUGGETS = new HashMap<String, TagKey<Item>>();
        public static final TagKey<Item> NUGGET = Items.forgeTag("nuggets");
        public static final Map<String, TagKey<Item>> INGOTS = new HashMap<String, TagKey<Item>>();
        public static final Map<String, TagKey<Item>> DUSTS = new HashMap<String, TagKey<Item>>();
        public static final Map<String, TagKey<Item>> SMALL_DUSTS = new HashMap<String, TagKey<Item>>();
        public static final TagKey<Item> SMALL_DUST = Items.forgeTag("small_dusts");
        public static final Map<String, TagKey<Item>> GEMS = new HashMap<String, TagKey<Item>>();
        public static final Map<String, TagKey<Item>> CRYSTALS = new HashMap<String, TagKey<Item>>();
        public static final TagKey<Item> CRYSTAL = Items.forgeTag("crystals");
        public static final Map<String, TagKey<Item>> PLATES = new HashMap<String, TagKey<Item>>();
        public static final TagKey<Item> PLATE = Items.forgeTag("plates");
        public static final Map<String, TagKey<Item>> CAST_PLATES = new HashMap<String, TagKey<Item>>();
        public static final TagKey<Item> CAST_PLATE = Items.forgeTag("cast_plates");
        public static final Map<String, TagKey<Item>> BILLETS = new HashMap<String, TagKey<Item>>();
        public static final TagKey<Item> BILLET = Items.forgeTag("billets");
        public static final Map<TagKey<Item>, Map<String, TagKey<Item>>> SERIALIZE_MAP = Map.of(NUGGET, NUGGETS, Tags.Items.INGOTS, INGOTS, Tags.Items.DUSTS, DUSTS, SMALL_DUST, SMALL_DUSTS, Tags.Items.GEMS, GEMS, CRYSTAL, CRYSTALS, PLATE, PLATES, CAST_PLATE, CAST_PLATES, BILLET, BILLETS);
        public static final TagKey<Item> BATTERY = Items.forgeTag("battery");
        public static final TagKey<Item> CHARGEABLE = Items.forgeTag("chargeable");
        public static final TagKey<Item> UPGRADE = Items.tag("upgrade");
        public static final TagKey<Item> MISSILE = Items.tag("missile");
        public static final TagKey<Item> SHREDDER_BLADES = Items.tag("shredder_blades");

        public static TagKey<Item> tag(String pName) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)HBM.rl(pName));
        }

        public static TagKey<Item> forgeTag(String pName) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", pName));
        }

        public static void loadTag() {
            BuiltInRegistries.f_257033_.m_203612_().forEach(pair -> {
                TagKey first = (TagKey)pair.getFirst();
                if (first.f_203868_().m_135827_().equals("hbm")) {
                    first.f_203868_().m_135815_().contains("nuggets");
                }
            });
        }
    }

    public static class Blocks {
        public static final Map<OreType, TagKey<Block>> MOD_ORES = new HashMap<OreType, TagKey<Block>>();
        public static final Map<String, TagKey<Block>> ORES;
        public static final Map<String, TagKey<Block>> STONE_ORES;
        public static final Map<String, TagKey<Block>> NETHER_ORES;
        public static final Map<String, TagKey<Block>> DEEPSLATE_ORES;
        public static final Map<String, TagKey<Block>> STORAGE_BLOCKS;
        public static final TagKey<Block> STORAGE_BLOCK;
        public static final Map<TagKey<Block>, Map<String, TagKey<Block>>> SERIALIZE_MAP;
        public static final TagKey<Block> BATTERY;
        public static final TagKey<Block> ANVIL;
        public static final TagKey<Block> MACHINE;

        private static TagKey<Block> tag(String pName) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)HBM.rl(pName));
        }

        public static TagKey<Block> forgeTag(String pName) {
            return TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("forge", pName));
        }

        static {
            for (OreType type : OreType.values()) {
                MOD_ORES.put(type, Blocks.forgeTag("ores/" + type.key));
            }
            ORES = new HashMap<String, TagKey<Block>>();
            STONE_ORES = new HashMap<String, TagKey<Block>>();
            NETHER_ORES = new HashMap<String, TagKey<Block>>();
            DEEPSLATE_ORES = new HashMap<String, TagKey<Block>>();
            STORAGE_BLOCKS = new HashMap<String, TagKey<Block>>();
            STORAGE_BLOCK = Blocks.forgeTag("storage_blocks");
            SERIALIZE_MAP = Map.of(Tags.Blocks.ORES, ORES, Tags.Blocks.ORES_IN_GROUND_STONE, STONE_ORES, Tags.Blocks.ORES_IN_GROUND_DEEPSLATE, DEEPSLATE_ORES, Tags.Blocks.ORES_IN_GROUND_NETHERRACK, NETHER_ORES, STORAGE_BLOCK, STORAGE_BLOCKS);
            BATTERY = Blocks.forgeTag("battery");
            ANVIL = Blocks.tag("anvil");
            MACHINE = Blocks.forgeTag("machine");
        }
    }
}

